/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils.tenant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.Tenant;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.TenantService;
import org.craftercms.security.utils.SecurityUtils;

public class TenantUtils {
    private TenantUtils() {
    }

    public static List<String> getTenantNames(TenantService tenantService) throws ProfileException {
        List tenants = tenantService.getAllTenants();
        ArrayList<String> tenantNames = new ArrayList<String>(tenants.size());
        if (CollectionUtils.isNotEmpty((Collection)tenants)) {
            for (Tenant tenant : tenants) {
                tenantNames.add(tenant.getName());
            }
        }
        return tenantNames;
    }

    public static String getCurrentTenantName() {
        Profile profile = SecurityUtils.getCurrentProfile();
        if (profile != null) {
            return profile.getTenant();
        }
        return null;
    }
}

