/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils.spring;

import java.beans.ConstructorProperties;
import org.craftercms.security.utils.SecurityEnabledAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class SecurityEnabledAwareProcessor
implements BeanPostProcessor {
    private boolean securityEnabled;

    @ConstructorProperties(value={"securityEnabled"})
    public SecurityEnabledAwareProcessor(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SecurityEnabledAware) {
            ((SecurityEnabledAware)bean).setSecurityEnabled(this.securityEnabled);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

