/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils.social;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.profile.api.Profile;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.UserProfile;

public class ConnectionUtils {
    public static final String CONNECTIONS_ATTRIBUTE_NAME = "connections";
    public static final String FIRST_NAME_ATTRIBUTE_NAME = "firstName";
    public static final String LAST_NAME_ATTRIBUTE_NAME = "lastName";
    public static final String DISPLAY_NAME_ATTRIBUTE_NAME = "displayName";
    public static final String AVATAR_LINK_ATTRIBUTE_NAME = "avatarLink";

    public static Map<String, Object> connectionDataToMap(ConnectionData connectionData, TextEncryptor encryptor) throws CryptoException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("providerUserId", connectionData.getProviderUserId());
        map.put(DISPLAY_NAME_ATTRIBUTE_NAME, connectionData.getDisplayName());
        map.put("profileUrl", connectionData.getProfileUrl());
        map.put("imageUrl", connectionData.getImageUrl());
        map.put("accessToken", ConnectionUtils.encrypt(connectionData.getAccessToken(), encryptor));
        map.put("secret", ConnectionUtils.encrypt(connectionData.getSecret(), encryptor));
        map.put("refreshToken", ConnectionUtils.encrypt(connectionData.getRefreshToken(), encryptor));
        map.put("expireTime", connectionData.getExpireTime());
        return map;
    }

    public static ConnectionData mapToConnectionData(String providerId, Map<String, Object> map, TextEncryptor encryptor) throws CryptoException {
        String providerUserId = (String)map.get("providerUserId");
        String displayName = (String)map.get(DISPLAY_NAME_ATTRIBUTE_NAME);
        String profileUrl = (String)map.get("profileUrl");
        String imageUrl = (String)map.get("imageUrl");
        String accessToken = ConnectionUtils.decrypt((String)map.get("accessToken"), encryptor);
        String secret = ConnectionUtils.decrypt((String)map.get("secret"), encryptor);
        String refreshToken = ConnectionUtils.decrypt((String)map.get("refreshToken"), encryptor);
        Long expireTime = (Long)map.get("expireTime");
        return new ConnectionData(providerId, providerUserId, displayName, profileUrl, imageUrl, accessToken, secret, refreshToken, expireTime);
    }

    public static void addConnectionData(Profile profile, ConnectionData connectionData, TextEncryptor encryptor) throws CryptoException {
        HashMap allConnections = (HashMap)profile.getAttribute(CONNECTIONS_ATTRIBUTE_NAME);
        ArrayList<Map<String, Object>> connectionsForProvider = null;
        if (allConnections == null) {
            allConnections = new HashMap();
            profile.setAttribute(CONNECTIONS_ATTRIBUTE_NAME, allConnections);
        } else {
            connectionsForProvider = (ArrayList<Map<String, Object>>)allConnections.get(connectionData.getProviderId());
        }
        if (connectionsForProvider == null) {
            connectionsForProvider = new ArrayList<Map<String, Object>>();
            allConnections.put(connectionData.getProviderId(), connectionsForProvider);
        }
        Map currentConnectionDataMap = null;
        for (Map map : connectionsForProvider) {
            if (!connectionData.getProviderUserId().equals(map.get("providerUserId"))) continue;
            currentConnectionDataMap = map;
            break;
        }
        if (currentConnectionDataMap != null) {
            currentConnectionDataMap.putAll(ConnectionUtils.connectionDataToMap(connectionData, encryptor));
        } else {
            connectionsForProvider.add(ConnectionUtils.connectionDataToMap(connectionData, encryptor));
        }
    }

    public static List<ConnectionData> getConnectionData(Profile profile, String providerId, TextEncryptor encryptor) throws CryptoException {
        List connectionsForProvider;
        Map allConnections = (Map)profile.getAttribute(CONNECTIONS_ATTRIBUTE_NAME);
        if (MapUtils.isNotEmpty((Map)allConnections) && CollectionUtils.isNotEmpty((Collection)(connectionsForProvider = (List)allConnections.get(providerId)))) {
            ArrayList<ConnectionData> connectionDataList = new ArrayList<ConnectionData>(connectionsForProvider.size());
            for (Map connectionDataMap : connectionsForProvider) {
                connectionDataList.add(ConnectionUtils.mapToConnectionData(providerId, connectionDataMap, encryptor));
            }
            return connectionDataList;
        }
        return Collections.emptyList();
    }

    public static void removeConnectionData(Profile profile, String providerId) {
        Map allConnections = (Map)profile.getAttribute(CONNECTIONS_ATTRIBUTE_NAME);
        if (MapUtils.isNotEmpty((Map)allConnections)) {
            allConnections.remove(providerId);
        }
    }

    public static void removeConnectionData(String providerId, String providerUserId, Profile profile) {
        List connectionsForProvider;
        Map allConnections = (Map)profile.getAttribute(CONNECTIONS_ATTRIBUTE_NAME);
        if (MapUtils.isNotEmpty((Map)allConnections) && CollectionUtils.isNotEmpty((Collection)(connectionsForProvider = (List)allConnections.get(providerId)))) {
            Iterator iter = connectionsForProvider.iterator();
            while (iter.hasNext()) {
                Map connectionDataMap = (Map)iter.next();
                if (!providerUserId.equals(connectionDataMap.get("providerUserId"))) continue;
                iter.remove();
            }
        }
    }

    public static void addProviderProfileInfo(Profile profile, UserProfile providerProfile) {
        String email = providerProfile.getEmail();
        if (StringUtils.isEmpty((CharSequence)email)) {
            throw new IllegalStateException("No email included in provider profile");
        }
        String username = providerProfile.getUsername();
        if (StringUtils.isEmpty((CharSequence)username)) {
            username = email;
        }
        String firstName = providerProfile.getFirstName();
        String lastName = providerProfile.getLastName();
        profile.setUsername(username);
        profile.setEmail(email);
        profile.setAttribute(FIRST_NAME_ATTRIBUTE_NAME, (Object)firstName);
        profile.setAttribute(LAST_NAME_ATTRIBUTE_NAME, (Object)lastName);
    }

    public static Profile createProfile(Connection<?> connection) {
        Profile profile = new Profile();
        UserProfile providerProfile = connection.fetchUserProfile();
        String email = providerProfile.getEmail();
        if (StringUtils.isEmpty((CharSequence)email)) {
            throw new IllegalStateException("No email included in provider profile");
        }
        String username = providerProfile.getUsername();
        if (StringUtils.isEmpty((CharSequence)username)) {
            username = email;
        }
        String firstName = providerProfile.getFirstName();
        String lastName = providerProfile.getLastName();
        Object displayName = StringUtils.isNotEmpty((CharSequence)connection.getDisplayName()) ? connection.getDisplayName() : firstName + " " + lastName;
        profile.setUsername(username);
        profile.setEmail(email);
        profile.setAttribute(FIRST_NAME_ATTRIBUTE_NAME, (Object)firstName);
        profile.setAttribute(LAST_NAME_ATTRIBUTE_NAME, (Object)lastName);
        profile.setAttribute(DISPLAY_NAME_ATTRIBUTE_NAME, displayName);
        if (StringUtils.isNotEmpty((CharSequence)connection.getImageUrl())) {
            profile.setAttribute(AVATAR_LINK_ATTRIBUTE_NAME, (Object)connection.getImageUrl());
        }
        return profile;
    }

    private static String encrypt(String clear, TextEncryptor encryptor) throws CryptoException {
        return encryptor != null && StringUtils.isNotEmpty((CharSequence)clear) ? encryptor.encrypt(clear) : clear;
    }

    private static String decrypt(String encrypted, TextEncryptor encryptor) throws CryptoException {
        return encryptor != null && StringUtils.isNotEmpty((CharSequence)encrypted) ? encryptor.decrypt(encrypted) : encrypted;
    }
}

