/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils.profile;

import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationCache;
import org.craftercms.security.authentication.impl.DefaultAuthentication;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;

@Aspect
public class RefreshCurrentAuthenticationOnProfileUpdateAspect {
    protected AuthenticationCache authenticationCache;

    @Required
    public void setAuthenticationCache(AuthenticationCache authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    @AfterReturning(value="execution(* org.craftercms.profile.api.services.ProfileService.updateProfile(..)) || execution(* org.craftercms.profile.api.services.ProfileService.verifyProfile(..)) || execution(* org.craftercms.profile.api.services.ProfileService.enableProfile(..)) || execution(* org.craftercms.profile.api.services.ProfileService.disableProfile(..)) || execution(* org.craftercms.profile.api.services.ProfileService.addRoles(..)) || execution(* org.craftercms.profile.api.services.ProfileService.removeRoles(..)) || execution(* org.craftercms.profile.api.services.ProfileService.updateAttributes(..)) || execution(* org.craftercms.profile.api.services.ProfileService.removeAttributes(..)) || execution(* org.craftercms.profile.api.services.ProfileService.changePassword(..))", returning="updatedProfile")
    public void refreshCurrentAuthentication(Profile updatedProfile) {
        Profile profile;
        Authentication auth = SecurityUtils.getCurrentAuthentication();
        if (auth != null && (profile = auth.getProfile()).equals((Object)updatedProfile)) {
            String ticket = auth.getTicket();
            auth = new DefaultAuthentication(ticket, updatedProfile);
            this.authenticationCache.putAuthentication(auth);
            SecurityUtils.setCurrentAuthentication(auth);
        }
    }
}

