/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils.handlers;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.rest.HttpMessageConvertingResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpMediaTypeNotAcceptableException;

public abstract class AbstractRestHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRestHandlerBase.class);
    protected HttpMessageConvertingResponseWriter responseWriter;

    @Required
    public void setResponseWriter(HttpMessageConvertingResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    protected <T> void sendObject(int status, T responseBody, RequestContext context) throws IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        response.setStatus(status);
        try {
            this.responseWriter.writeWithMessageConverters(responseBody, request, response);
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            logger.error(e.getMessage(), (Throwable)e);
            response.sendError(400, e.getMessage());
        }
    }

    protected void sendMessage(int status, String message, RequestContext context) throws IOException {
        this.sendObject(status, Collections.singletonMap("message", message), context);
    }

    protected void sendErrorMessage(int status, Throwable e, RequestContext context) throws IOException {
        this.sendMessage(status, e.getLocalizedMessage(), context);
    }
}

