/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.utils;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
    public static final String AUTHENTICATION_EXCEPTION_SESSION_ATTRIBUTE = "authenticationException";
    public static final String BAD_CREDENTIALS_EXCEPTION_SESSION_ATTRIBUTE = "badCredentialsException";
    public static final String ACCESS_DENIED_EXCEPTION_SESSION_ATTRIBUTE = "accessDeniedException";
    public static final String TICKET_COOKIE_NAME = "ticket";
    public static final String PROFILE_LAST_MODIFIED_COOKIE_NAME = "profile-last-modified";
    public static final String TENANT_REQUEST_ATTRIBUTE_NAME = "tenant";
    public static final String AUTHENTICATION_REQUEST_ATTRIBUTE_NAME = "authentication";

    private SecurityUtils() {
    }

    public static String getTicketCookie(HttpServletRequest request) {
        return HttpUtils.getCookieValue((String)TICKET_COOKIE_NAME, (HttpServletRequest)request);
    }

    public static Long getProfileLastModifiedCookie(HttpServletRequest request) {
        String profileLastModified = HttpUtils.getCookieValue((String)PROFILE_LAST_MODIFIED_COOKIE_NAME, (HttpServletRequest)request);
        if (StringUtils.isNotEmpty((CharSequence)profileLastModified)) {
            try {
                return new Long(profileLastModified);
            }
            catch (NumberFormatException e) {
                logger.error("Invalid profile last modified cookie format: {}", (Object)profileLastModified);
            }
        }
        return null;
    }

    public static Authentication getCurrentAuthentication() {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            return SecurityUtils.getAuthentication(context.getRequest());
        }
        return null;
    }

    public static void setCurrentAuthentication(Authentication authentication) {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            SecurityUtils.setAuthentication(context.getRequest(), authentication);
        }
    }

    public static void removeCurrentAuthentication() {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            SecurityUtils.removeAuthentication(context.getRequest());
        }
    }

    public static Authentication getAuthentication(HttpServletRequest request) {
        return (Authentication)request.getAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE_NAME);
    }

    public static void setAuthentication(HttpServletRequest request, Authentication authentication) {
        request.setAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE_NAME, (Object)authentication);
    }

    public static void removeAuthentication(HttpServletRequest request) {
        request.removeAttribute(AUTHENTICATION_REQUEST_ATTRIBUTE_NAME);
    }

    public static Profile getCurrentProfile() {
        RequestContext context = RequestContext.getCurrent();
        if (context != null) {
            return SecurityUtils.getProfile(context.getRequest());
        }
        return null;
    }

    public static Profile getProfile(HttpServletRequest request) {
        Authentication auth = SecurityUtils.getAuthentication(request);
        if (auth != null) {
            return auth.getProfile();
        }
        return null;
    }
}

