/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.social.impl;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.exception.AuthenticationException;
import org.craftercms.security.exception.OAuth2Exception;
import org.craftercms.security.social.ProviderLoginSupport;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.security.utils.social.ConnectionUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.connect.web.ConnectSupport;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

public class ProviderLoginSupportImpl
implements ProviderLoginSupport {
    public static final String PARAM_OAUTH_TOKEN = "oauth_token";
    public static final String PARAM_CODE = "code";
    public static final String PARAM_ERROR = "error";
    public static final String PARAM_ERROR_DESCRIPTION = "error_description";
    public static final String PARAM_ERROR_URI = "error_uri";
    protected ConnectSupport connectSupport = new ConnectSupport();
    protected ConnectionFactoryLocator connectionFactoryLocator;
    protected ProfileService profileService;
    protected AuthenticationManager authenticationManager;
    protected TextEncryptor textEncryptor;

    public void setConnectSupport(ConnectSupport connectSupport) {
        this.connectSupport = connectSupport;
    }

    @Required
    public void setConnectionFactoryLocator(ConnectionFactoryLocator connectionFactoryLocator) {
        this.connectionFactoryLocator = connectionFactoryLocator;
    }

    @Required
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Required
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Required
    public void setTextEncryptor(TextEncryptor textEncryptor) {
        this.textEncryptor = textEncryptor;
    }

    @Override
    public String start(String tenant, String providerId, HttpServletRequest request) throws AuthenticationException {
        return this.start(tenant, providerId, request, null, null);
    }

    @Override
    public String start(String tenant, String providerId, HttpServletRequest request, MultiValueMap<String, String> additionalUrlParams) throws AuthenticationException {
        return this.start(tenant, providerId, request, additionalUrlParams, null);
    }

    @Override
    public String start(String tenant, String providerId, HttpServletRequest request, MultiValueMap<String, String> additionalUrlParams, ConnectSupport connectSupport) throws AuthenticationException {
        if (connectSupport == null) {
            connectSupport = this.connectSupport;
        }
        ConnectionFactory<?> connectionFactory = this.getConnectionFactory(providerId);
        ServletWebRequest webRequest = new ServletWebRequest(request);
        return connectSupport.buildOAuthUrl(connectionFactory, (NativeWebRequest)webRequest, additionalUrlParams);
    }

    @Override
    public Authentication complete(String tenant, String providerId, HttpServletRequest request) throws AuthenticationException {
        return this.complete(tenant, providerId, request, null, null, null);
    }

    @Override
    public Authentication complete(String tenant, String providerId, HttpServletRequest request, Set<String> newUserRoles, Map<String, Object> newUserAttributes) throws AuthenticationException {
        return this.complete(tenant, providerId, request, newUserRoles, newUserAttributes, null);
    }

    @Override
    public Authentication complete(String tenant, String providerId, HttpServletRequest request, Set<String> newUserRoles, Map<String, Object> newUserAttributes, ConnectSupport connectSupport) throws AuthenticationException {
        Connection<?> connection;
        if (connectSupport == null) {
            connectSupport = this.connectSupport;
        }
        if ((connection = this.completeConnection(connectSupport, providerId, request)) != null) {
            Profile userData = ConnectionUtils.createProfile(connection);
            Profile profile = this.getProfile(tenant, userData);
            if (profile == null) {
                if (CollectionUtils.isNotEmpty(newUserRoles)) {
                    userData.getRoles().addAll(newUserRoles);
                }
                if (MapUtils.isNotEmpty(newUserAttributes)) {
                    userData.getAttributes().putAll(newUserAttributes);
                }
                profile = this.createProfile(tenant, connection, userData);
            } else {
                profile = this.updateProfileConnectionData(tenant, connection, profile);
            }
            Authentication auth = this.authenticationManager.authenticateUser(profile);
            SecurityUtils.setAuthentication(request, auth);
            return auth;
        }
        return null;
    }

    protected Connection<?> completeConnection(ConnectSupport connectSupport, String providerId, HttpServletRequest request) throws OAuth2Exception {
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter(PARAM_OAUTH_TOKEN))) {
            OAuth1ConnectionFactory connectionFactory = (OAuth1ConnectionFactory)this.getConnectionFactory(providerId);
            ServletWebRequest webRequest = new ServletWebRequest(request);
            return connectSupport.completeConnection(connectionFactory, (NativeWebRequest)webRequest);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter(PARAM_CODE))) {
            OAuth2ConnectionFactory connectionFactory = (OAuth2ConnectionFactory)this.getConnectionFactory(providerId);
            ServletWebRequest webRequest = new ServletWebRequest(request);
            return connectSupport.completeConnection(connectionFactory, (NativeWebRequest)webRequest);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getParameter(PARAM_ERROR))) {
            String error = request.getParameter(PARAM_ERROR);
            String errorDescription = request.getParameter(PARAM_ERROR_DESCRIPTION);
            String errorUri = request.getParameter(PARAM_ERROR_URI);
            throw new OAuth2Exception(error, errorDescription, errorUri);
        }
        return null;
    }

    protected ConnectionFactory<?> getConnectionFactory(String providerId) {
        return this.connectionFactoryLocator.getConnectionFactory(providerId);
    }

    protected Profile getProfile(String tenant, Profile userData) {
        try {
            return this.profileService.getProfileByUsername(tenant, userData.getUsername(), new String[0]);
        }
        catch (ProfileException e) {
            throw new AuthenticationException("Unable to retrieve current profile for user '" + userData.getUsername() + "' of tenant '" + tenant + "'", e);
        }
    }

    protected Profile createProfile(String tenant, Connection<?> connection, Profile userData) {
        try {
            ConnectionUtils.addConnectionData(userData, connection.createData(), this.textEncryptor);
            return this.profileService.createProfile(tenant, userData.getUsername(), null, userData.getEmail(), true, userData.getRoles(), userData.getAttributes(), null);
        }
        catch (CryptoException | ProfileException e) {
            throw new AuthenticationException("Unable to create profile of user '" + userData.getUsername() + "' in tenant '" + tenant + "'", e);
        }
    }

    protected Profile updateProfileConnectionData(String tenant, Connection<?> connection, Profile profile) {
        try {
            ConnectionUtils.addConnectionData(profile, connection.createData(), this.textEncryptor);
            return this.profileService.updateAttributes(profile.getId().toString(), profile.getAttributes(), new String[0]);
        }
        catch (CryptoException | ProfileException e) {
            throw new AuthenticationException("Unable to update connection data of user '" + profile.getUsername() + "' of tenant '" + tenant + "'", e);
        }
    }
}

