/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.servlet.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.processors.impl.RequestSecurityProcessorChainImpl;
import org.craftercms.security.utils.SecurityEnabledAware;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class RequestSecurityFilter
extends GenericFilterBean
implements SecurityEnabledAware {
    protected boolean securityEnabled;
    protected List<RequestSecurityProcessor> securityProcessors;
    protected String[] urlsToInclude;
    protected String[] urlsToExclude;
    protected PathMatcher pathMatcher = new AntPathMatcher();

    @Override
    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    @Required
    public void setSecurityProcessors(List<RequestSecurityProcessor> securityProcessors) {
        this.securityProcessors = securityProcessors;
    }

    public void setUrlsToInclude(String ... urlsToInclude) {
        this.urlsToInclude = urlsToInclude;
    }

    public void setUrlsToExclude(String ... urlsToExclude) {
        this.urlsToExclude = urlsToExclude;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.securityEnabled && (this.includeRequest(httpRequest) || !this.excludeRequest(httpRequest))) {
            this.doFilterInternal((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestContext context = RequestContext.getCurrent();
        if (context == null) {
            context = this.createRequestContext(request, response);
        }
        ArrayList<RequestSecurityProcessor> finalSecurityProcessors = new ArrayList<RequestSecurityProcessor>(this.securityProcessors);
        finalSecurityProcessors.add(this.getLastProcessorInChain(chain));
        Iterator<RequestSecurityProcessor> processorIter = finalSecurityProcessors.iterator();
        RequestSecurityProcessorChainImpl processorChain = new RequestSecurityProcessorChainImpl(processorIter);
        try {
            processorChain.processRequest(context);
        }
        catch (IOException | RuntimeException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean excludeRequest(HttpServletRequest request) {
        if (ArrayUtils.isNotEmpty((Object[])this.urlsToExclude)) {
            for (String pathPattern : this.urlsToExclude) {
                if (!this.pathMatcher.match(pathPattern, HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)request))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean includeRequest(HttpServletRequest request) {
        if (ArrayUtils.isNotEmpty((Object[])this.urlsToInclude)) {
            for (String pathPattern : this.urlsToInclude) {
                if (!this.pathMatcher.match(pathPattern, HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)request))) continue;
                return true;
            }
        }
        return false;
    }

    protected RequestContext createRequestContext(HttpServletRequest request, HttpServletResponse response) {
        return new RequestContext(request, response, this.getServletContext());
    }

    protected RequestSecurityProcessor getLastProcessorInChain(final FilterChain chain) {
        return new RequestSecurityProcessor(){

            @Override
            public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
                chain.doFilter((ServletRequest)context.getRequest(), (ServletResponse)context.getResponse());
            }
        };
    }
}

