/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.exception.AccessDeniedException;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.security.utils.spring.el.AccessRestrictionExpressionRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class UrlAccessRestrictionCheckingProcessor
implements RequestSecurityProcessor {
    public static final Logger logger = LoggerFactory.getLogger(UrlAccessRestrictionCheckingProcessor.class);
    protected PathMatcher pathMatcher = new AntPathMatcher();
    protected Map<String, Expression> urlRestrictions;

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
    }

    @Required
    public void setUrlRestrictions(Map<String, String> restrictions) {
        this.urlRestrictions = new LinkedHashMap<String, Expression>();
        SpelExpressionParser parser = new SpelExpressionParser();
        for (Map.Entry<String, String> entry : restrictions.entrySet()) {
            this.urlRestrictions.put(entry.getKey(), parser.parseExpression(entry.getValue()));
        }
    }

    protected Map<String, Expression> getUrlRestrictions() {
        return this.urlRestrictions;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        Map<String, Expression> urlRestrictions = this.getUrlRestrictions();
        if (MapUtils.isNotEmpty(urlRestrictions)) {
            HttpServletRequest request = context.getRequest();
            String requestUrl = this.getRequestUrl(context.getRequest());
            logger.debug("Checking access restrictions for URL {}", (Object)requestUrl);
            for (Map.Entry<String, Expression> entry : urlRestrictions.entrySet()) {
                String urlPattern = entry.getKey();
                Expression expression = entry.getValue();
                if (!this.pathMatcher.match(urlPattern, requestUrl)) continue;
                logger.debug("Checking restriction [{} => {}]", (Object)requestUrl, (Object)expression.getExpressionString());
                if (this.isAccessAllowed(request, expression)) {
                    logger.debug("Restriction [{}' => {}] evaluated to true for user: access allowed", (Object)requestUrl, (Object)expression.getExpressionString());
                    break;
                }
                throw new AccessDeniedException("Restriction ['" + requestUrl + "' => " + expression.getExpressionString() + "] evaluated to false for user: access denied");
            }
        }
        processorChain.processRequest(context);
    }

    protected String getRequestUrl(HttpServletRequest request) {
        return HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)request);
    }

    protected boolean isAccessAllowed(HttpServletRequest request, Expression expression) {
        Object value = expression.getValue(this.createExpressionRoot(request));
        if (!(value instanceof Boolean)) {
            throw new IllegalStateException("Expression " + expression.getExpressionString() + " should return a boolean value");
        }
        return (Boolean)value;
    }

    protected Object createExpressionRoot(HttpServletRequest request) {
        AccessRestrictionExpressionRoot root = new AccessRestrictionExpressionRoot();
        Authentication auth = SecurityUtils.getAuthentication(request);
        if (auth != null) {
            root.setProfile(auth.getProfile());
        }
        return root;
    }
}

