/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationRequiredHandler;
import org.craftercms.security.authorization.AccessDeniedHandler;
import org.craftercms.security.exception.AccessDeniedException;
import org.craftercms.security.exception.AuthenticationRequiredException;
import org.craftercms.security.exception.SecurityProviderException;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class SecurityExceptionProcessor
implements RequestSecurityProcessor {
    public static final Logger logger = LoggerFactory.getLogger(SecurityExceptionProcessor.class);
    protected AuthenticationRequiredHandler authenticationRequiredHandler;
    protected AccessDeniedHandler accessDeniedHandler;

    @Required
    public void setAuthenticationRequiredHandler(AuthenticationRequiredHandler authenticationRequiredHandler) {
        this.authenticationRequiredHandler = authenticationRequiredHandler;
    }

    @Required
    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        this.accessDeniedHandler = accessDeniedHandler;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        try {
            processorChain.processRequest(context);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            SecurityProviderException se = this.findSecurityException(e);
            if (se != null) {
                this.handleSecurityProviderException(se, context);
            }
            throw e;
        }
    }

    public SecurityProviderException findSecurityException(Exception topException) {
        Throwable[] exceptionChain;
        for (Throwable e : exceptionChain = ExceptionUtils.getThrowables((Throwable)topException)) {
            if (!(e instanceof SecurityProviderException)) continue;
            return (SecurityProviderException)e;
        }
        return null;
    }

    protected void handleSecurityProviderException(SecurityProviderException e, RequestContext context) throws SecurityProviderException, IOException {
        if (e instanceof AuthenticationRequiredException) {
            this.handleAuthenticationRequiredException(context, (AuthenticationRequiredException)e);
        } else if (e instanceof AccessDeniedException) {
            this.handleAccessDeniedException(context, (AccessDeniedException)e);
        } else {
            throw e;
        }
    }

    protected void handleAuthenticationRequiredException(RequestContext context, AuthenticationRequiredException e) throws SecurityProviderException, IOException {
        logger.debug("Authentication is required", (Throwable)e);
        this.authenticationRequiredHandler.handle(context, e);
    }

    protected void handleAccessDeniedException(RequestContext context, AccessDeniedException e) throws SecurityProviderException, IOException {
        Authentication auth = SecurityUtils.getAuthentication(context.getRequest());
        if (auth == null) {
            try {
                throw new AuthenticationRequiredException("Authentication required to access the resource", e);
            }
            catch (AuthenticationRequiredException ae) {
                logger.debug("Authentication is required", (Throwable)ae);
                this.authenticationRequiredHandler.handle(context, ae);
            }
        } else {
            logger.debug("Access denied to user '" + auth.getProfile().getUsername() + "'", (Throwable)e);
            this.accessDeniedHandler.handle(context, e);
        }
    }
}

