/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

public class SavedRequestAwareProcessor
implements RequestSecurityProcessor {
    public static final Logger logger = LoggerFactory.getLogger(SavedRequestAwareProcessor.class);
    protected RequestCache requestCache = new HttpSessionRequestCache();

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        HttpServletResponse response;
        HttpServletRequest request = context.getRequest();
        HttpServletRequest wrappedSavedRequest = this.requestCache.getMatchingRequest(request, response = context.getResponse());
        if (wrappedSavedRequest != null) {
            logger.debug("A previously saved request was found, and has been merged with the current request");
            context.setRequest(wrappedSavedRequest);
        }
        processorChain.processRequest(context);
    }
}

