/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.rest.HttpMessageConvertingResponseWriter;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpMediaTypeNotAcceptableException;

public class ReturnCurrentAuthenticationProcessor
implements RequestSecurityProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ReturnCurrentAuthenticationProcessor.class);
    public static final String DEFAULT_SERVICE_URL = "/crafter-security-current-auth";
    public static final String DEFAULT_SERVICE_METHOD = "GET";
    private String serviceUrl = "/crafter-security-current-auth";
    private String serviceMethod = "GET";
    private HttpMessageConvertingResponseWriter responseWriter;

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public void setResponseWriter(HttpMessageConvertingResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (this.isServiceRequest(request)) {
            this.sendAuthentication(SecurityUtils.getAuthentication(request), context);
        } else {
            processorChain.processRequest(context);
        }
    }

    protected boolean isServiceRequest(HttpServletRequest request) {
        return HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)request).equals(this.serviceUrl) && request.getMethod().equals(this.serviceMethod);
    }

    protected <T> void sendAuthentication(Authentication auth, RequestContext context) throws IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        if (auth != null) {
            response.setStatus(200);
            try {
                this.responseWriter.writeWithMessageConverters((Object)auth, request, response);
            }
            catch (HttpMediaTypeNotAcceptableException e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.sendError(400, e.getMessage());
            }
        } else {
            response.setStatus(204);
        }
    }
}

