/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.util.Iterator;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSecurityProcessorChainImpl
implements RequestSecurityProcessorChain {
    private static final Logger logger = LoggerFactory.getLogger(RequestSecurityProcessorChainImpl.class);
    private Iterator<RequestSecurityProcessor> processorIterator;

    public RequestSecurityProcessorChainImpl(Iterator<RequestSecurityProcessor> processorIterator) {
        this.processorIterator = processorIterator;
    }

    @Override
    public void processRequest(RequestContext context) throws Exception {
        if (this.processorIterator.hasNext()) {
            RequestSecurityProcessor processor = this.processorIterator.next();
            logger.debug("Executing processor {}", (Object)processor);
            processor.processRequest(context, this);
        }
    }
}

