/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.RememberMeManager;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;

public class RememberMeAutoLoginProcessor
implements RequestSecurityProcessor {
    protected RememberMeManager rememberMeManager;

    @Required
    public void setRememberMeManager(RememberMeManager rememberMeManager) {
        this.rememberMeManager = rememberMeManager;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        Authentication auth = SecurityUtils.getAuthentication(context.getRequest());
        if (auth == null && (auth = this.rememberMeManager.autoLogin(context)) != null) {
            SecurityUtils.setAuthentication(context.getRequest(), auth);
        }
        processorChain.processRequest(context);
    }
}

