/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.authentication.LogoutSuccessHandler;
import org.craftercms.security.authentication.RememberMeManager;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class LogoutProcessor
implements RequestSecurityProcessor {
    public static final Logger logger = LoggerFactory.getLogger(LogoutProcessor.class);
    public static final String DEFAULT_LOGOUT_URL = "/crafter-security-logout";
    public static final String DEFAULT_LOGOUT_METHOD = "GET";
    protected String logoutUrl = "/crafter-security-logout";
    protected String logoutMethod = "GET";
    protected AuthenticationManager authenticationManager;
    protected LogoutSuccessHandler logoutSuccessHandler;
    protected RememberMeManager rememberMeManager;

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void setLogoutMethod(String logoutMethod) {
        this.logoutMethod = logoutMethod;
    }

    @Required
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Required
    public void setLogoutSuccessHandler(LogoutSuccessHandler logoutSuccessHandler) {
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    @Required
    public void setRememberMeManager(RememberMeManager rememberMeManager) {
        this.rememberMeManager = rememberMeManager;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        if (this.isLogoutRequest(context.getRequest())) {
            logger.debug("Processing logout request");
            Authentication auth = SecurityUtils.getAuthentication(context.getRequest());
            if (auth != null) {
                this.authenticationManager.invalidateAuthentication(auth);
            }
            this.onLogoutSuccess(context, auth);
        } else {
            processorChain.processRequest(context);
        }
    }

    protected boolean isLogoutRequest(HttpServletRequest request) {
        return HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)request).equals(this.logoutUrl) && request.getMethod().equals(this.logoutMethod);
    }

    protected void onLogoutSuccess(RequestContext context, Authentication authentication) throws IOException {
        if (authentication != null) {
            logger.debug("Logout for user '" + authentication.getProfile().getUsername() + "' successful");
            if (authentication.isRemembered()) {
                this.rememberMeManager.disableRememberMe(context);
            }
            SecurityUtils.removeAuthentication(context.getRequest());
            HttpSession session = context.getRequest().getSession();
            if (session != null) {
                try {
                    session.invalidate();
                    context.getRequest().getSession(true);
                }
                catch (IllegalStateException ex) {
                    logger.debug("Http Session was already invalidated");
                }
            }
        } else {
            logger.debug("No logout done: user wasn't authenticated");
        }
        this.logoutSuccessHandler.handle(context);
    }
}

