/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.authentication.LoginFailureHandler;
import org.craftercms.security.authentication.LoginSuccessHandler;
import org.craftercms.security.authentication.RememberMeManager;
import org.craftercms.security.exception.AuthenticationException;
import org.craftercms.security.exception.BadCredentialsException;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.security.utils.tenant.TenantsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class LoginProcessor
implements RequestSecurityProcessor {
    public static final Logger logger = LoggerFactory.getLogger(LoginProcessor.class);
    public static final String DEFAULT_LOGIN_URL = "/crafter-security-login";
    public static final String DEFAULT_LOGIN_METHOD = "POST";
    public static final String DEFAULT_USERNAME_PARAM = "username";
    public static final String DEFAULT_PASSWORD_PARAM = "password";
    public static final String DEFAULT_REMEMBER_ME_PARAM = "rememberMe";
    protected String loginUrl = "/crafter-security-login";
    protected String loginMethod = "POST";
    protected String usernameParameter = "username";
    protected String passwordParameter = "password";
    protected String rememberMeParameter = "rememberMe";
    protected TenantsResolver tenantsResolver;
    protected AuthenticationManager authenticationManager;
    protected LoginSuccessHandler loginSuccessHandler;
    protected LoginFailureHandler loginFailureHandler;
    protected RememberMeManager rememberMeManager;

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setRememberMeParameter(String rememberMeParameter) {
        this.rememberMeParameter = rememberMeParameter;
    }

    @Required
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Required
    public void setLoginSuccessHandler(LoginSuccessHandler loginSuccessHandler) {
        this.loginSuccessHandler = loginSuccessHandler;
    }

    @Required
    public void setLoginFailureHandler(LoginFailureHandler loginFailureHandler) {
        this.loginFailureHandler = loginFailureHandler;
    }

    @Required
    public void setRememberMeManager(RememberMeManager rememberMeManager) {
        this.rememberMeManager = rememberMeManager;
    }

    @Required
    public void setTenantsResolver(TenantsResolver tenantsResolver) {
        this.tenantsResolver = tenantsResolver;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        HttpServletRequest request = context.getRequest();
        if (this.isLoginRequest(request)) {
            logger.debug("Processing login request");
            Object[] tenants = this.tenantsResolver.getTenants();
            if (ArrayUtils.isEmpty((Object[])tenants)) {
                throw new IllegalArgumentException("No tenants resolved for authentication");
            }
            String username = this.getUsername(request);
            String password = this.getPassword(request);
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            try {
                logger.debug("Attempting authentication of user '{}' with tenants {}", (Object)username, (Object)tenants);
                Authentication auth = this.authenticationManager.authenticateUser((String[])tenants, username, password);
                if (this.getRememberMe(request)) {
                    this.rememberMeManager.enableRememberMe(auth, context);
                } else {
                    this.rememberMeManager.disableRememberMe(context);
                }
                this.onLoginSuccess(context, auth);
            }
            catch (AuthenticationException e) {
                this.onLoginFailure(context, e);
            }
        } else {
            processorChain.processRequest(context);
        }
    }

    protected boolean isLoginRequest(HttpServletRequest request) {
        return HttpUtils.getRequestUriWithoutContextPath((HttpServletRequest)request).equals(this.loginUrl) && request.getMethod().equals(this.loginMethod);
    }

    protected String getUsername(HttpServletRequest request) {
        return request.getParameter(this.usernameParameter);
    }

    protected String getPassword(HttpServletRequest request) {
        return request.getParameter(this.passwordParameter);
    }

    protected boolean getRememberMe(HttpServletRequest request) {
        return BooleanUtils.toBoolean((String)request.getParameter(this.rememberMeParameter));
    }

    protected void onLoginSuccess(RequestContext context, Authentication authentication) throws Exception {
        logger.info("Login successful for user '" + authentication.getProfile().getUsername() + "'");
        HttpServletRequest request = context.getRequest();
        this.clearSession(request);
        SecurityUtils.setAuthentication(request, authentication);
        this.loginSuccessHandler.handle(context, authentication);
    }

    protected void onLoginFailure(RequestContext context, AuthenticationException e) throws Exception {
        logger.debug("Login failed", (Throwable)e);
        this.saveException(context.getRequest(), e);
        this.loginFailureHandler.handle(context, e);
    }

    protected void saveException(HttpServletRequest request, AuthenticationException e) {
        logger.debug("Saving authentication exception in session for later use");
        HttpSession session = request.getSession(true);
        if (e instanceof BadCredentialsException) {
            session.setAttribute("badCredentialsException", (Object)e);
        } else {
            session.setAttribute("authenticationException", (Object)e);
        }
    }

    protected void clearSession(HttpServletRequest request) {
        logger.debug("Removing any authentication exceptions from session, not needed anymore");
        try {
            request.getSession().invalidate();
        }
        catch (IllegalStateException ex) {
            logger.debug("Session was already invalidated");
        }
        request.getSession(true);
    }
}

