/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class CurrentAuthenticationResolvingProcessor
implements RequestSecurityProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CurrentAuthenticationResolvingProcessor.class);
    protected AuthenticationManager authenticationManager;

    @Required
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        String ticket;
        HttpServletRequest request = context.getRequest();
        Authentication auth = null;
        if (SecurityUtils.getAuthentication(request) == null && (ticket = SecurityUtils.getTicketCookie(request)) != null && (auth = this.authenticationManager.getAuthentication(ticket, false)) != null) {
            Long profileLastModified = SecurityUtils.getProfileLastModifiedCookie(request);
            long currentProfileLastModified = auth.getProfile().getLastModified().getTime();
            if (profileLastModified == null || currentProfileLastModified != profileLastModified) {
                if (profileLastModified == null) {
                    logger.debug("Not profile last modified timestamp specified in request");
                } else {
                    logger.debug("The last modified timestamp in request doesn't match the current one");
                }
                auth = this.authenticationManager.getAuthentication(ticket, true);
            }
        }
        if (auth != null) {
            SecurityUtils.setAuthentication(request, auth);
        }
        processorChain.processRequest(context);
    }
}

