/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.profile.api.AttributeDefinition;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.Tenant;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.profile.api.services.TenantService;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.security.utils.tenant.TenantsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class AuthenticationHeadersLoginProcessor
implements RequestSecurityProcessor {
    public static final Logger logger = LoggerFactory.getLogger(AuthenticationHeadersLoginProcessor.class);
    public static final String DEFAULT_MELLON_HEADER_PREFIX = "MELLON_";
    public static final String DEFAULT_USERNAME_HEADER_NAME = "MELLON_username";
    public static final String DEFAULT_EMAIL_HEADER_NAME = "MELLON_email";
    public static final String DEFAULT_TOKEN_HEADER_NAME = "MELLON_secure_key";
    protected TenantService tenantService;
    protected ProfileService profileService;
    protected TenantsResolver tenantsResolver;
    protected AuthenticationManager authenticationManager;
    protected String mellonHeaderPrefix = "MELLON_";
    protected String usernameHeaderName = "MELLON_username";
    protected String emailHeaderName = "MELLON_email";
    protected String tokenHeaderName = "MELLON_secure_key";
    protected String tokenExpectedValue;

    @Required
    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Required
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Required
    public void setTenantsResolver(TenantsResolver tenantsResolver) {
        this.tenantsResolver = tenantsResolver;
    }

    @Required
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setMellonHeaderPrefix(String mellonHeaderPrefix) {
        this.mellonHeaderPrefix = mellonHeaderPrefix;
    }

    public void setUsernameHeaderName(String usernameHeaderName) {
        this.usernameHeaderName = usernameHeaderName;
    }

    public void setEmailHeaderName(String emailHeaderName) {
        this.emailHeaderName = emailHeaderName;
    }

    public void setTokenHeaderName(String tokenHeaderName) {
        this.tokenHeaderName = tokenHeaderName;
    }

    public void setTokenExpectedValue(String tokenExpectedValue) {
        this.tokenExpectedValue = tokenExpectedValue;
    }

    public String getTokenExpectedValue() {
        return this.tokenExpectedValue;
    }

    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        HttpServletRequest request = context.getRequest();
        String username = request.getHeader(this.usernameHeaderName);
        Authentication auth = SecurityUtils.getAuthentication(request);
        if (StringUtils.isNotEmpty((CharSequence)username) && (Objects.isNull(auth) || !auth.getProfile().getUsername().equals(username)) && this.hasValidToken(request)) {
            Object[] tenantNames = this.tenantsResolver.getTenants();
            Tenant tenant = this.getSsoEnabledTenant((String[])tenantNames);
            if (tenant != null) {
                Profile profile = this.profileService.getProfileByUsername(tenant.getName(), username, new String[0]);
                if (profile == null) {
                    profile = this.createProfileWithSsoInfo(username, tenant, request);
                }
                SecurityUtils.setAuthentication(request, this.authenticationManager.authenticateUser(profile));
            } else {
                logger.warn("An SSO login was attempted, but none of the tenants [{}] is enabled for SSO", tenantNames);
            }
        }
        processorChain.processRequest(context);
    }

    protected boolean hasValidToken(HttpServletRequest request) {
        String tokenHeaderValue = request.getHeader(this.tokenHeaderName);
        if (StringUtils.equals((CharSequence)tokenHeaderValue, (CharSequence)this.getTokenExpectedValue())) {
            return true;
        }
        logger.warn("Token mismatch during authentication from '{}'", (Object)request.getRemoteAddr());
        return false;
    }

    protected Tenant getSsoEnabledTenant(String[] tenantNames) throws ProfileException {
        for (String tenantName : tenantNames) {
            Tenant tenant = this.tenantService.getTenant(tenantName);
            if (tenant == null || !tenant.isSsoEnabled()) continue;
            return tenant;
        }
        return null;
    }

    protected Profile createProfileWithSsoInfo(String username, Tenant tenant, HttpServletRequest request) throws ProfileException {
        HashMap<String, String> attributes = null;
        List attributeDefinitions = tenant.getAttributeDefinitions();
        String email = request.getHeader(this.emailHeaderName);
        for (AttributeDefinition attributeDefinition : attributeDefinitions) {
            String attributeName = attributeDefinition.getName();
            String attributeValue = request.getHeader(this.mellonHeaderPrefix + attributeName);
            if (!StringUtils.isNotEmpty((CharSequence)attributeValue)) continue;
            if (attributes == null) {
                attributes = new HashMap<String, String>();
            }
            attributes.put(attributeName, attributeValue);
        }
        logger.info("Creating new profile with SSO info: username={}, email={}, tenant={}, attributes={}", new Object[]{username, email, tenant.getName(), attributes});
        return this.profileService.createProfile(tenant.getName(), username, null, email, true, null, attributes, null);
    }
}

