/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.processors.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.CookieManager;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.processors.RequestSecurityProcessor;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class AddSecurityCookiesProcessor
implements RequestSecurityProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AddSecurityCookiesProcessor.class);
    protected CookieManager ticketCookieManager;
    protected CookieManager profileLastModifiedCookieManager;

    @Required
    public void setTicketCookieManager(CookieManager ticketCookieManager) {
        this.ticketCookieManager = ticketCookieManager;
    }

    @Required
    public void setProfileLastModifiedCookieManager(CookieManager profileLastModifiedCookieManager) {
        this.profileLastModifiedCookieManager = profileLastModifiedCookieManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        AddSecurityCookiesResponseWrapper response = this.wrapResponse(context);
        context.setResponse((HttpServletResponse)response);
        logger.debug("Wrapped response in a {}", (Object)((Object)((Object)response)).getClass().getName());
        try {
            processorChain.processRequest(context);
        }
        finally {
            response.addCookies();
        }
    }

    protected AddSecurityCookiesResponseWrapper wrapResponse(RequestContext context) {
        return new AddSecurityCookiesResponseWrapper(context.getRequest(), context.getResponse());
    }

    protected class AddSecurityCookiesResponseWrapper
    extends HttpServletResponseWrapper {
        protected HttpServletRequest request;
        protected boolean cookiesAdded;

        public AddSecurityCookiesResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.request = request;
            this.cookiesAdded = false;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.addCookies();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            this.addCookies();
            return super.getWriter();
        }

        public void sendError(int sc) throws IOException {
            this.addCookies();
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.addCookies();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.addCookies();
            super.sendRedirect(location);
        }

        public void flushBuffer() throws IOException {
            this.addCookies();
            super.flushBuffer();
        }

        public void addCookies() {
            if (!this.cookiesAdded) {
                Authentication auth = SecurityUtils.getAuthentication(this.request);
                if (auth != null) {
                    String ticket = SecurityUtils.getTicketCookie(this.request);
                    Long profileLastModified = SecurityUtils.getProfileLastModifiedCookie(this.request);
                    long currentProfileLastModified = auth.getProfile().getLastModified().getTime();
                    if (StringUtils.isEmpty((CharSequence)ticket) || !ticket.equals(auth.getTicket())) {
                        this.addTicketCookie(auth.getTicket());
                    }
                    if (profileLastModified == null || currentProfileLastModified != profileLastModified) {
                        this.addProfileLastModifiedCookie(currentProfileLastModified);
                    }
                } else {
                    String ticket = SecurityUtils.getTicketCookie(this.request);
                    Long profileLastModified = SecurityUtils.getProfileLastModifiedCookie(this.request);
                    if (StringUtils.isNotEmpty((CharSequence)ticket)) {
                        this.deleteTicketCookie();
                    }
                    if (profileLastModified != null) {
                        this.deleteProfileLastModifiedCookie();
                    }
                }
                this.cookiesAdded = true;
            }
        }

        protected void addTicketCookie(String ticket) {
            AddSecurityCookiesProcessor.this.ticketCookieManager.addCookie("ticket", ticket, (HttpServletResponse)this);
        }

        protected void addProfileLastModifiedCookie(long lastModified) {
            AddSecurityCookiesProcessor.this.profileLastModifiedCookieManager.addCookie("profile-last-modified", String.valueOf(lastModified), (HttpServletResponse)this);
        }

        protected void deleteTicketCookie() {
            AddSecurityCookiesProcessor.this.ticketCookieManager.deleteCookie("ticket", (HttpServletResponse)this);
        }

        protected void deleteProfileLastModifiedCookie() {
            AddSecurityCookiesProcessor.this.profileLastModifiedCookieManager.deleteCookie("profile-last-modified", (HttpServletResponse)this);
        }
    }
}

