/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.authorization.impl;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authorization.AccessDeniedHandler;
import org.craftercms.security.exception.AccessDeniedException;
import org.craftercms.security.exception.SecurityProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessDeniedHandlerImpl
implements AccessDeniedHandler {
    private static final Logger logger = LoggerFactory.getLogger(AccessDeniedHandlerImpl.class);
    protected String errorPageUrl;

    public void setErrorPageUrl(String errorPageUrl) {
        this.errorPageUrl = errorPageUrl;
    }

    protected String getErrorPageUrl() {
        return this.errorPageUrl;
    }

    @Override
    public void handle(RequestContext context, AccessDeniedException e) throws SecurityProviderException, IOException {
        this.saveException(context, e);
        if (StringUtils.isNotEmpty((CharSequence)this.getErrorPageUrl())) {
            this.forwardToErrorPage(context);
        } else {
            this.sendError(e, context);
        }
    }

    protected void saveException(RequestContext context, AccessDeniedException e) {
        logger.debug("Saving access denied exception in request to use after forward");
        context.getRequest().setAttribute("accessDeniedException", (Object)e);
    }

    protected void forwardToErrorPage(RequestContext context) throws SecurityProviderException, IOException {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String errorPageUrl = this.getErrorPageUrl();
        response.setStatus(403);
        logger.debug("Forwarding to error page at {}, with 403 FORBIDDEN status", (Object)errorPageUrl);
        RequestDispatcher dispatcher = request.getRequestDispatcher(errorPageUrl);
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            throw new SecurityProviderException(e.getMessage(), e);
        }
    }

    protected void sendError(AccessDeniedException e, RequestContext requestContext) throws IOException {
        logger.debug("Sending 403 FORBIDDEN error");
        requestContext.getResponse().sendError(403, e.getMessage());
    }
}

