/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.authentication.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.crypto.CryptoException;
import org.craftercms.commons.crypto.TextEncryptor;
import org.craftercms.commons.http.CookieManager;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.profile.api.PersistentLogin;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.AuthenticationService;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.AuthenticationManager;
import org.craftercms.security.authentication.RememberMeManager;
import org.craftercms.security.authentication.impl.AuthenticationManagerImpl;
import org.craftercms.security.exception.AuthenticationException;
import org.craftercms.security.exception.AuthenticationSystemException;
import org.craftercms.security.exception.rememberme.CookieTheftException;
import org.craftercms.security.exception.rememberme.InvalidCookieException;
import org.craftercms.security.exception.rememberme.RememberMeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class RememberMeManagerImpl
implements RememberMeManager {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationManagerImpl.class);
    public static final String REMEMBER_ME_COOKIE_NAME = "remember-me";
    public static final char SERIALIZED_LOGIN_SEPARATOR = ':';
    protected AuthenticationService authenticationService;
    protected AuthenticationManager authenticationManager;
    protected ProfileService profileService;
    protected TextEncryptor encryptor;
    protected CookieManager rememberMeCookieManager;

    @Required
    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Required
    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Required
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Required
    public void setEncryptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Required
    public void setRememberMeCookieManager(CookieManager rememberMeCookieManager) {
        this.rememberMeCookieManager = rememberMeCookieManager;
    }

    @Override
    public Authentication autoLogin(RequestContext context) throws RememberMeException {
        PersistentLogin login = this.getPersistentLoginFromCookie(context.getRequest());
        if (login != null) {
            PersistentLogin actualLogin;
            try {
                actualLogin = this.authenticationService.getPersistentLogin(login.getId());
            }
            catch (ProfileException e) {
                throw new RememberMeException("Error retrieving persistent login '" + login.getProfileId() + "'");
            }
            if (actualLogin != null) {
                Authentication auth;
                if (!login.getProfileId().equals(actualLogin.getProfileId())) {
                    throw new InvalidCookieException("Profile ID mismatch");
                }
                if (!login.getToken().equals(actualLogin.getToken())) {
                    throw new CookieTheftException("Token mismatch. Implies a cookie theft");
                }
                String loginId = actualLogin.getId();
                String profileId = actualLogin.getProfileId();
                logger.debug("Remember me cookie match for {}. Starting auto-login", (Object)actualLogin);
                try {
                    auth = this.authenticate(profileId);
                }
                catch (AuthenticationException e) {
                    this.disableRememberMe(loginId, context);
                    throw new RememberMeException("Unable to auto-login user '" + profileId + "'", e);
                }
                this.updateRememberMe(loginId, context);
                return auth;
            }
            logger.debug("No persistent login found for ID '{}' (has possibly expired)", (Object)login.getId());
            this.deleteRememberMeCookie(context.getResponse());
            return null;
        }
        return null;
    }

    @Override
    public void enableRememberMe(Authentication authentication, RequestContext context) throws RememberMeException {
        PersistentLogin login;
        String profileId = authentication.getProfile().getId().toString();
        try {
            login = this.authenticationService.createPersistentLogin(profileId);
        }
        catch (ProfileException e) {
            throw new RememberMeException("Error creating persistent login for profile '" + profileId + "'", e);
        }
        logger.debug("Persistent login created: {}", (Object)login);
        this.addRememberMeCookie(this.serializeLogin(login), context.getResponse());
    }

    @Override
    public void disableRememberMe(RequestContext context) throws RememberMeException {
        PersistentLogin login = this.getPersistentLoginFromCookie(context.getRequest());
        if (login != null) {
            this.disableRememberMe(login.getId(), context);
        }
    }

    protected void disableRememberMe(String loginId, RequestContext context) throws RememberMeException {
        this.deleteRememberMeCookie(context.getResponse());
        try {
            this.authenticationService.deletePersistentLogin(loginId);
        }
        catch (ProfileException e) {
            throw new RememberMeException("Error invalidating persistent login '" + loginId + "'");
        }
        logger.debug("Persistent login '{}' invalidated", (Object)loginId);
    }

    protected void updateRememberMe(String loginId, RequestContext context) throws RememberMeException {
        PersistentLogin login;
        try {
            login = this.authenticationService.refreshPersistentLoginToken(loginId);
        }
        catch (ProfileException e) {
            throw new RememberMeException("Unable to update persistent login '" + loginId + "'", e);
        }
        logger.debug("Persistent login updated: {}", (Object)login);
        this.addRememberMeCookie(this.serializeLogin(login), context.getResponse());
    }

    protected String serializeLogin(PersistentLogin login) throws RememberMeException {
        StringBuilder serializedLogin = new StringBuilder();
        serializedLogin.append(login.getId()).append(':');
        serializedLogin.append(login.getProfileId()).append(':');
        serializedLogin.append(login.getToken());
        try {
            return this.encryptor.encrypt(serializedLogin.toString());
        }
        catch (CryptoException e) {
            throw new RememberMeException("Unable to encrypt remember me cookie", e);
        }
    }

    protected PersistentLogin deserializeLogin(String serializedLogin) throws RememberMeException {
        String decryptedLogin;
        try {
            decryptedLogin = this.encryptor.decrypt(serializedLogin);
        }
        catch (CryptoException e) {
            throw new RememberMeException("Unable to decrypt remember me cookie", e);
        }
        Object[] splitSerializedLogin = StringUtils.split((String)decryptedLogin, (char)':');
        if (ArrayUtils.isNotEmpty((Object[])splitSerializedLogin) && splitSerializedLogin.length == 3) {
            PersistentLogin login = new PersistentLogin();
            login.setId((String)splitSerializedLogin[0]);
            login.setProfileId((String)splitSerializedLogin[1]);
            login.setToken((String)splitSerializedLogin[2]);
            return login;
        }
        throw new InvalidCookieException("Invalid format of remember me cookie");
    }

    protected void addRememberMeCookie(String cookieValue, HttpServletResponse response) {
        this.rememberMeCookieManager.addCookie(REMEMBER_ME_COOKIE_NAME, cookieValue, response);
    }

    protected String getRememberMeCookie(HttpServletRequest request) {
        return HttpUtils.getCookieValue((String)REMEMBER_ME_COOKIE_NAME, (HttpServletRequest)request);
    }

    protected void deleteRememberMeCookie(HttpServletResponse response) {
        this.rememberMeCookieManager.deleteCookie(REMEMBER_ME_COOKIE_NAME, response);
    }

    protected PersistentLogin getPersistentLoginFromCookie(HttpServletRequest request) {
        String cookie = this.getRememberMeCookie(request);
        if (StringUtils.isNotEmpty((CharSequence)cookie)) {
            return this.deserializeLogin(cookie);
        }
        return null;
    }

    protected Authentication authenticate(String profileId) throws AuthenticationException {
        Profile profile;
        try {
            profile = this.profileService.getProfile(profileId, new String[0]);
        }
        catch (ProfileException e) {
            throw new AuthenticationSystemException("Error retrieving profile '" + profileId + "'", e);
        }
        if (profile != null) {
            return this.authenticationManager.authenticateUser(profile, true);
        }
        throw new AuthenticationSystemException("No profile found for ID '" + profileId + "'");
    }
}

