/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.authentication.impl;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.authentication.LoginSuccessHandler;
import org.craftercms.security.exception.SecurityProviderException;
import org.craftercms.security.utils.RedirectUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class LoginSuccessHandlerImpl
implements LoginSuccessHandler {
    protected RequestCache requestCache = new HttpSessionRequestCache();
    protected String defaultTargetUrl;
    protected boolean alwaysUseDefaultTargetUrl = false;

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    @Required
    public void setDefaultTargetUrl(String defaultTargetUrl) {
        this.defaultTargetUrl = defaultTargetUrl;
    }

    protected String getDefaultTargetUrl() {
        return this.defaultTargetUrl;
    }

    public void setAlwaysUseDefaultTargetUrl(boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    protected boolean isAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    @Override
    public void handle(RequestContext context, Authentication authentication) throws SecurityProviderException, IOException {
        this.redirectToSavedRequest(context.getRequest(), context.getResponse());
    }

    protected void redirectToSavedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (!this.isAlwaysUseDefaultTargetUrl() && savedRequest != null) {
            RedirectUtils.redirect(request, response, savedRequest.getRedirectUrl());
        } else {
            RedirectUtils.redirect(request, response, this.getDefaultTargetUrl());
        }
    }
}

