/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.authentication.impl;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.LoginFailureHandler;
import org.craftercms.security.exception.AuthenticationException;
import org.craftercms.security.exception.SecurityProviderException;
import org.craftercms.security.utils.RedirectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginFailureHandlerImpl
implements LoginFailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoginFailureHandlerImpl.class);
    protected String targetUrl;

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    protected String getTargetUrl() {
        return this.targetUrl;
    }

    @Override
    public void handle(RequestContext context, AuthenticationException e) throws SecurityProviderException, IOException {
        String targetUrl = this.getTargetUrl();
        if (StringUtils.isNotEmpty((CharSequence)targetUrl)) {
            RedirectUtils.redirect(context.getRequest(), context.getResponse(), targetUrl);
        } else {
            this.sendError(e, context);
        }
    }

    protected void sendError(AuthenticationException e, RequestContext context) throws IOException {
        logger.debug("Sending 401 UNAUTHORIZED error");
        context.getResponse().sendError(401, e.getMessage());
    }
}

