/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.authentication.impl;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.security.authentication.AuthenticationRequiredHandler;
import org.craftercms.security.exception.AuthenticationException;
import org.craftercms.security.exception.SecurityProviderException;
import org.craftercms.security.utils.RedirectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

public class AuthenticationRequiredHandlerImpl
implements AuthenticationRequiredHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationRequiredHandlerImpl.class);
    protected String loginFormUrl;
    protected RequestCache requestCache = new HttpSessionRequestCache();

    public void setLoginFormUrl(String loginFormUrl) {
        this.loginFormUrl = loginFormUrl;
    }

    protected String getLoginFormUrl() {
        return this.loginFormUrl;
    }

    public void setRequestCache(RequestCache requestCache) {
        this.requestCache = requestCache;
    }

    @Override
    public void handle(RequestContext context, AuthenticationException e) throws SecurityProviderException, IOException {
        this.saveRequest(context);
        String loginFormUrl = this.getLoginFormUrl();
        if (StringUtils.isNotEmpty((CharSequence)loginFormUrl)) {
            RedirectUtils.redirect(context.getRequest(), context.getResponse(), loginFormUrl);
        } else {
            this.sendError(e, context);
        }
    }

    protected void saveRequest(RequestContext context) {
        logger.debug("Saving current request for use after login");
        this.requestCache.saveRequest(context.getRequest(), context.getResponse());
    }

    protected void sendError(AuthenticationException e, RequestContext context) throws IOException {
        logger.debug("Sending 401 UNAUTHORIZED error");
        context.getResponse().sendError(401, e.getMessage());
    }
}

