/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.security.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.craftercms.security.utils.SecurityEnabledAware;

@Aspect
public class RunIfSecurityEnabledAspect
implements SecurityEnabledAware {
    private boolean securityEnabled;

    @Override
    public void setSecurityEnabled(boolean securityEnabled) {
        this.securityEnabled = securityEnabled;
    }

    @Around(value="@annotation(org.craftercms.security.annotations.RunIfSecurityEnabled)")
    public Object runIfSecurityEnabled(ProceedingJoinPoint pjp) throws Throwable {
        if (this.securityEnabled) {
            return pjp.proceed();
        }
        return null;
    }
}

