/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.management.web.controllers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.security.exception.ActionDeniedException;
import org.craftercms.profile.api.AccessToken;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.AccessTokenService;
import org.craftercms.profile.management.exceptions.ResourceNotFoundException;
import org.craftercms.profile.management.security.AuthorizationUtils;
import org.craftercms.profile.management.security.permissions.Action;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/access_token"})
public class AccessTokenController {
    public static final String BASE_URL_ACCESS_TOKEN = "/access_token";
    public static final String PATH_VAR_ID = "id";
    public static final String URL_VIEW_ACCESS_TOKEN_LIST = "/list/view";
    public static final String URL_VIEW_NEW_ACCESS_TOKEN = "/new/view";
    public static final String URL_VIEW_ACCESS_TOKEN = "/view";
    public static final String URL_GET_ALL_ACCESS_TOKENS = "/all";
    public static final String URL_GET_ACCESS_TOKEN = "/{id}";
    public static final String URL_CREATE_ACCESS_TOKEN = "/create";
    public static final String URL_DELETE_ACCESS_TOKEN = "/{id}/delete";
    public static final String VIEW_ACCESS_TOKEN_LIST = "access-token-list";
    public static final String VIEW_NEW_ACCESS_TOKEN = "new-access-token";
    public static final String VIEW_ACCESS_TOKEN = "access-token";
    public static final String MODEL_MESSAGE = "message";
    public static final String MSG_ACCESS_TOKEN_CREATED_FORMAT = "Access token '%s' created";
    public static final String MSG_ACCESS_TOKEN_DELETED_FORMAT = "Access token '%s' deleted";
    private AccessTokenService accessTokenService;

    @Required
    public void setAccessTokenService(AccessTokenService accessTokenService) {
        this.accessTokenService = accessTokenService;
    }

    @RequestMapping(value={"/list/view"}, method={RequestMethod.GET})
    public String viewAccessTokenList() throws ProfileException {
        return VIEW_ACCESS_TOKEN_LIST;
    }

    @RequestMapping(value={"/new/view"}, method={RequestMethod.GET})
    public String viewNewAccessToken() throws ProfileException {
        return VIEW_NEW_ACCESS_TOKEN;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewAccessToken() throws ProfileException {
        return VIEW_ACCESS_TOKEN;
    }

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AccessToken> getAllAccessTokens() throws ProfileException {
        this.checkIfAllowed(null, Action.GET_ALL_ACCESS_TOKENS);
        return this.accessTokenService.getAllTokens();
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public AccessToken getAccessToken(@PathVariable(value="id") String id) throws ProfileException {
        this.checkIfAllowed(id, Action.GET_PROFILE);
        AccessToken token = this.accessTokenService.getToken(id);
        if (token != null) {
            return token;
        }
        throw new ResourceNotFoundException("No access token found with ID '" + id + "'");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> createAccessToken(@RequestBody AccessToken token) throws ProfileException {
        this.checkIfAllowed(null, Action.CREATE_ACCESS_TOKEN);
        token = this.accessTokenService.createToken(token);
        return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_ACCESS_TOKEN_CREATED_FORMAT, token.getId()));
    }

    @RequestMapping(value={"/{id}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> deleteAccessToken(@PathVariable(value="id") String id) throws ProfileException {
        this.checkIfAllowed(id, Action.DELETE_ACCESS_TOKEN);
        this.accessTokenService.deleteToken(id);
        return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_ACCESS_TOKEN_DELETED_FORMAT, id));
    }

    private void checkIfAllowed(String tokenId, Action action) throws ActionDeniedException {
        if (!AuthorizationUtils.isSuperadmin((Profile)SecurityUtils.getCurrentProfile())) {
            if (tokenId != null) {
                throw new ActionDeniedException(action.toString(), (Object)tokenId);
            }
            throw new ActionDeniedException(action.toString());
        }
    }
}

