/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.management.security.permissions;

import org.craftercms.commons.security.exception.PermissionException;
import org.craftercms.commons.security.permissions.Permission;
import org.craftercms.commons.security.permissions.PermissionResolver;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.management.security.AuthorizationUtils;
import org.craftercms.profile.management.security.permissions.ProfileAdminTenantPermission;
import org.craftercms.profile.management.security.permissions.SuperadminPermission;
import org.craftercms.profile.management.security.permissions.TenantAdminTenantPermission;

public class TenantPermissionResolver
implements PermissionResolver<Profile, String> {
    public Permission getGlobalPermission(Profile currentUser) throws PermissionException {
        if (AuthorizationUtils.isSuperadmin((Profile)currentUser)) {
            return new SuperadminPermission();
        }
        return null;
    }

    public Permission getPermission(Profile currentUser, String tenant) throws PermissionException {
        if (AuthorizationUtils.isSuperadmin((Profile)currentUser)) {
            return new SuperadminPermission();
        }
        if (AuthorizationUtils.isTenantAdmin((Profile)currentUser)) {
            return new TenantAdminTenantPermission(currentUser, tenant);
        }
        return new ProfileAdminTenantPermission(currentUser, tenant);
    }
}

