/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.serializer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.coursera.metrics.datadog.model.DatadogCounter;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer
implements Serializer {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(JSON_FACTORY);
    private static final Logger LOG = LoggerFactory.getLogger(JsonSerializer.class);
    private JsonGenerator jsonOut;
    private ByteArrayOutputStream outputStream;

    @Override
    public void startObject() throws IOException {
        this.outputStream = new ByteArrayOutputStream(2048);
        this.jsonOut = JSON_FACTORY.createGenerator((OutputStream)this.outputStream);
        this.jsonOut.writeStartObject();
        this.jsonOut.writeArrayFieldStart("series");
    }

    @Override
    public void appendGauge(DatadogGauge gauge) throws IOException {
        MAPPER.writeValue(this.jsonOut, (Object)gauge);
    }

    @Override
    public void appendCounter(DatadogCounter counter) throws IOException {
        MAPPER.writeValue(this.jsonOut, (Object)counter);
    }

    @Override
    public void endObject() throws IOException {
        this.jsonOut.writeEndArray();
        this.jsonOut.writeEndObject();
        this.jsonOut.flush();
        this.outputStream.close();
    }

    @Override
    public String getAsString() throws UnsupportedEncodingException {
        return this.outputStream.toString("UTF-8");
    }
}

