/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagsMerger {
    private static final Logger LOG = LoggerFactory.getLogger(TagsMerger.class);

    TagsMerger() {
    }

    static List<String> mergeTags(List<String> tags1, List<String> tags2) {
        if (tags1 == null || tags1.isEmpty()) {
            return tags2;
        }
        if (tags2 == null || tags2.isEmpty()) {
            return tags1;
        }
        ArrayList<String> newTags = new ArrayList<String>();
        newTags.addAll(tags1);
        newTags.addAll(tags2);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String string : newTags) {
            String[] strs = string.split(":");
            if (strs.length != 2) {
                LOG.warn("Invalid tag: " + string);
                continue;
            }
            map.put(strs[0], strs[1]);
        }
        newTags.clear();
        for (Map.Entry entry : map.entrySet()) {
            newTags.add(entry.getKey() + ":" + entry.getValue());
        }
        return newTags;
    }
}

