/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog.transport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.util.Duration;
import javax.validation.constraints.NotNull;
import org.coursera.metrics.datadog.transport.AbstractTransportFactory;
import org.coursera.metrics.datadog.transport.HttpTransport;

@JsonTypeName(value="http")
public class HttpTransportFactory
implements AbstractTransportFactory {
    @NotNull
    @JsonProperty
    private String apiKey = null;
    @JsonProperty
    private Duration connectTimeout = Duration.seconds((long)5L);
    @JsonProperty
    private Duration socketTimeout = Duration.seconds((long)5L);
    @JsonProperty
    private int proxyPort;
    @JsonProperty
    private String proxyHost;

    public HttpTransport build() {
        HttpTransport.Builder builder = new HttpTransport.Builder().withApiKey(this.apiKey).withConnectTimeout((int)this.connectTimeout.toMilliseconds()).withSocketTimeout((int)this.socketTimeout.toMilliseconds());
        if (this.proxyPort != 0 || this.proxyHost != null) {
            if (this.proxyPort == 0 || this.proxyHost == null) {
                throw new IllegalStateException("must set both proxyPort and proxyHost or neither");
            }
            builder.withProxy(this.proxyHost, this.proxyPort);
        }
        return builder.build();
    }
}

