/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMapType;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ContextMapSemanticsValidator
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateThatRelationshipContextArePartOfMap(ContextMap map) {
        for (Relationship relationship : map.getRelationships()) {
            BoundedContext context1 = null;
            BoundedContext context2 = null;
            EReference attributeRelContext1 = null;
            EReference attributeRelContext2 = null;
            if (relationship instanceof SymmetricRelationship) {
                context1 = ((SymmetricRelationship)relationship).getParticipant1();
                context2 = ((SymmetricRelationship)relationship).getParticipant2();
                attributeRelContext1 = ContextMappingDSLPackage.Literals.SYMMETRIC_RELATIONSHIP__PARTICIPANT1;
                attributeRelContext2 = ContextMappingDSLPackage.Literals.SYMMETRIC_RELATIONSHIP__PARTICIPANT2;
            } else if (relationship instanceof UpstreamDownstreamRelationship) {
                context1 = ((UpstreamDownstreamRelationship)relationship).getUpstream();
                context2 = ((UpstreamDownstreamRelationship)relationship).getDownstream();
                attributeRelContext1 = ContextMappingDSLPackage.Literals.UPSTREAM_DOWNSTREAM_RELATIONSHIP__UPSTREAM;
                attributeRelContext2 = ContextMappingDSLPackage.Literals.UPSTREAM_DOWNSTREAM_RELATIONSHIP__DOWNSTREAM;
            }
            if (context1 != null && !this.isContextPartOfMap(map, context1)) {
                this.error(String.format("The Bounded Context '%s' is not part of the Context Map.", context1.getName()), relationship, (EStructuralFeature)attributeRelContext1);
            }
            if (context2 == null || this.isContextPartOfMap(map, context2)) continue;
            this.error(String.format("The Bounded Context '%s' is not part of the Context Map.", context2.getName()), relationship, (EStructuralFeature)attributeRelContext2);
        }
    }

    @Check
    public void validateThatExposedAggregateIsPartOfUpstreamContext(ContextMap map) {
        for (Relationship rel : map.getRelationships()) {
            if (!(rel instanceof UpstreamDownstreamRelationship)) continue;
            UpstreamDownstreamRelationship relationship = (UpstreamDownstreamRelationship)rel;
            BoundedContext upstreamContext = relationship.getUpstream();
            int aggregateRefIndex = 0;
            for (Aggregate aggregate : relationship.getUpstreamExposedAggregates()) {
                List aggregates = upstreamContext.getAggregates().stream().map(a -> a.getName()).collect(Collectors.toList());
                for (SculptorModule module : upstreamContext.getModules()) {
                    aggregates.addAll(module.getAggregates().stream().map(b -> b.getName()).collect(Collectors.toList()));
                }
                if (!aggregates.contains(aggregate.getName())) {
                    this.error(String.format("The aggregate '%s' is not part of the upstream context '%s'.", aggregate.getName(), upstreamContext.getName()), relationship, (EStructuralFeature)ContextMappingDSLPackage.Literals.UPSTREAM_DOWNSTREAM_RELATIONSHIP__UPSTREAM_EXPOSED_AGGREGATES, aggregateRefIndex);
                }
                ++aggregateRefIndex;
            }
        }
    }

    @Check
    public void validateBoundedContextTypes(ContextMap map) {
        if (ContextMapType.ORGANIZATIONAL.equals((Object)map.getType())) {
            if (!map.getBoundedContexts().stream().anyMatch(bc -> bc.getType() == BoundedContextType.TEAM)) {
                this.warning("Your Context Map is of the type ORGANIZATIONAL but does not contain Bounded Contexts of the type TEAM. This type of Context Map is intended to model team relationships.", map, (EStructuralFeature)ContextMappingDSLPackage.Literals.CONTEXT_MAP__TYPE);
            }
        } else if (ContextMapType.SYSTEM_LANDSCAPE.equals((Object)map.getType())) {
            for (BoundedContext bc2 : map.getBoundedContexts()) {
                if (!BoundedContextType.TEAM.equals((Object)bc2.getType())) continue;
                this.error(String.format("A Bounded Context of type 'TEAM' is not allowed on a SYSTEM_LANDSCAPE map.", new Object[0]), map, (EStructuralFeature)ContextMappingDSLPackage.Literals.CONTEXT_MAP__BOUNDED_CONTEXTS);
            }
        }
    }

    private boolean isContextPartOfMap(ContextMap map, BoundedContext context) {
        return map.getBoundedContexts().contains((Object)context);
    }
}

