/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.ContextMappingModelHelper;
import org.contextmapper.dsl.refactoring.ContextSplittingIntegrationType;
import org.contextmapper.dsl.refactoring.RefactoringHelper;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class SplitSystemIntoSubsystems
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String systemExistingBoundedContextName;
    private String existingSubsystemName;
    private String newSubsystemName;
    private SplitBoundedContextRelationshipType relationshipType = SplitBoundedContextRelationshipType.NEW_CONTEXT_BECOMES_DOWNSTREAM;
    private ContextSplittingIntegrationType integrationType = ContextSplittingIntegrationType.CONFORMIST;
    private boolean copyDomainModel = false;
    private String newSubsystemImplementationTechnology = "";
    private String newRelationshipImplementationTechnology = "";
    private RefactoringHelper helper;

    public SplitSystemIntoSubsystems(String systemExistingBoundedContextName, String existingSubsystemName, String newSubsystemName) {
        this.systemExistingBoundedContextName = systemExistingBoundedContextName;
        this.existingSubsystemName = existingSubsystemName;
        this.newSubsystemName = newSubsystemName;
        this.helper = new RefactoringHelper(this);
    }

    @Override
    protected void doRefactor() {
        this.checkPreconditions();
        this.deleteExistingContexts();
        BoundedContext systemContext = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.systemExistingBoundedContextName)).findFirst().get();
        this.renameBoundedContext(systemContext.getName(), this.existingSubsystemName);
        BoundedContext newSubsystemContext = this.createNewSubsystemBC(systemContext);
        newSubsystemContext.setName(this.newSubsystemName);
        newSubsystemContext.setType(BoundedContextType.SYSTEM);
        newSubsystemContext.setImplementationTechnology(this.newSubsystemImplementationTechnology);
        this.addElementToEList(this.model.getBoundedContexts(), newSubsystemContext);
        this.createUpstreamDownstreamRelationship(systemContext, newSubsystemContext);
    }

    private void deleteExistingContexts() {
        Optional<BoundedContext> optNewSubsystem = this.model.getBoundedContexts().stream().filter(bc -> bc.getName().equals(this.newSubsystemName)).findFirst();
        Optional<BoundedContext> optExistingSubsystem = this.model.getBoundedContexts().stream().filter(bc -> bc.getName().equals(this.existingSubsystemName)).findFirst();
        if (optNewSubsystem.isPresent()) {
            this.removeContextFromMap(optNewSubsystem.get());
        }
        if (!this.systemExistingBoundedContextName.equals(this.existingSubsystemName) && optExistingSubsystem.isPresent()) {
            this.removeContextFromMap(optExistingSubsystem.get());
        }
    }

    private void removeContextFromMap(BoundedContext bc) {
        if (this.model.getMap() != null) {
            ContextMappingModelHelper mappingHelper = new ContextMappingModelHelper(this.model.getMap());
            for (Relationship relationship : mappingHelper.findAnyRelationshipsInvolvingContext(bc)) {
                this.removeElementFromEList(this.model.getMap().getRelationships(), relationship);
            }
            if (this.model.getMap().getBoundedContexts().contains((Object)bc)) {
                this.removeElementFromEList(this.model.getMap().getBoundedContexts(), bc);
            }
        }
        this.removeElementFromEList(this.model.getBoundedContexts(), bc);
    }

    private void renameBoundedContext(String currentName, String newName) {
        List allInstances = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.systemExistingBoundedContextName)).collect(Collectors.toList());
        for (ContextMap contextMap : this.getAllContextMaps()) {
            allInstances.addAll(contextMap.getBoundedContexts().stream().filter(bc -> bc.getName().equals(this.systemExistingBoundedContextName)).collect(Collectors.toList()));
            allInstances.addAll(this.getAllRelationshipContextsByName(contextMap, currentName));
        }
        for (BoundedContext bc2 : allInstances) {
            bc2.setName(newName);
        }
    }

    private List<BoundedContext> getAllRelationshipContextsByName(ContextMap map, String contextName) {
        LinkedList contexts = Lists.newLinkedList();
        for (Relationship rel : map.getRelationships()) {
            if (rel instanceof UpstreamDownstreamRelationship) {
                UpstreamDownstreamRelationship upDownRel = (UpstreamDownstreamRelationship)rel;
                if (upDownRel.getDownstream().getName().equals(contextName)) {
                    contexts.add(upDownRel.getDownstream());
                }
                if (!upDownRel.getUpstream().getName().equals(contextName)) continue;
                contexts.add(upDownRel.getUpstream());
                continue;
            }
            if (!(rel instanceof SymmetricRelationship)) continue;
            SymmetricRelationship symRel = (SymmetricRelationship)rel;
            if (symRel.getParticipant1().getName().equals(contextName)) {
                contexts.add(symRel.getParticipant1());
            }
            if (!symRel.getParticipant2().getName().equals(contextName)) continue;
            contexts.add(symRel.getParticipant2());
        }
        return contexts;
    }

    private void createUpstreamDownstreamRelationship(BoundedContext existingContext, BoundedContext newContext) {
        UpstreamDownstreamRelationship relationship = ContextMappingDSLFactory.eINSTANCE.createUpstreamDownstreamRelationship();
        if (this.relationshipType == SplitBoundedContextRelationshipType.NEW_CONTEXT_BECOMES_DOWNSTREAM) {
            relationship.setDownstream(newContext);
            relationship.setUpstream(existingContext);
            this.addElementsToEList(relationship.getUpstreamExposedAggregates(), existingContext.getAggregates());
        } else {
            relationship.setDownstream(existingContext);
            relationship.setUpstream(newContext);
            this.addElementsToEList(relationship.getUpstreamExposedAggregates(), newContext.getAggregates());
        }
        if (this.integrationType == ContextSplittingIntegrationType.CONFORMIST) {
            relationship.getDownstreamRoles().add((Object)DownstreamRole.CONFORMIST);
        } else {
            relationship.getDownstreamRoles().add((Object)DownstreamRole.ANTICORRUPTION_LAYER);
        }
        relationship.getUpstreamRoles().add((Object)UpstreamRole.PUBLISHED_LANGUAGE);
        relationship.setImplementationTechnology(this.newRelationshipImplementationTechnology);
        ContextMap map = this.createOrGetContextMap();
        this.addElementToEList(map.getBoundedContexts(), newContext);
        this.addElementToEList(map.getBoundedContexts(), existingContext);
        this.addElementToEList(map.getRelationships(), relationship);
    }

    private BoundedContext createNewSubsystemBC(BoundedContext existingSubsystem) {
        if (this.copyDomainModel) {
            BoundedContext copiedContext = (BoundedContext)EcoreUtil.copy((EObject)existingSubsystem);
            this.helper.adjustAggregateAndModuleNames(copiedContext, "_" + this.newSubsystemName);
            return copiedContext;
        }
        return ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
    }

    private ContextMap createOrGetContextMap() {
        if (this.model.getMap() != null) {
            return this.model.getMap();
        }
        ContextMap newContextMap = ContextMappingDSLFactory.eINSTANCE.createContextMap();
        this.model.setMap(newContextMap);
        return newContextMap;
    }

    private void checkPreconditions() {
        Optional<BoundedContext> optSystemBC = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.systemExistingBoundedContextName)).findFirst();
        if (!optSystemBC.isPresent()) {
            throw new RefactoringInputException("A Bounded Context with the name '" + this.systemExistingBoundedContextName + "' does not exist!");
        }
        BoundedContext systemBC = optSystemBC.get();
        if (systemBC.getType() != BoundedContextType.SYSTEM) {
            throw new RefactoringInputException("The Bounded Context '" + this.systemExistingBoundedContextName + "' is not of the type FEATURE!");
        }
    }

    public void setRelationshipType(SplitBoundedContextRelationshipType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public void setIntegrationType(ContextSplittingIntegrationType integrationType) {
        this.integrationType = integrationType;
    }

    public void copyDomainModel(boolean copyDomainModel) {
        this.copyDomainModel = copyDomainModel;
    }

    public void setNewSubsystemImplementationTechnology(String newSubsystemImplementationTechnology) {
        this.newSubsystemImplementationTechnology = newSubsystemImplementationTechnology;
    }

    public void setNewRelationshipImplementationTechnology(String newRelationshipImplementationTechnology) {
        this.newRelationshipImplementationTechnology = newRelationshipImplementationTechnology;
    }

    public static enum SplitBoundedContextRelationshipType {
        NEW_CONTEXT_BECOMES_UPSTREAM("Upstream"),
        NEW_CONTEXT_BECOMES_DOWNSTREAM("Downstream");

        private String label;

        private SplitBoundedContextRelationshipType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static SplitBoundedContextRelationshipType byLabel(String label) {
            if (label != null && "Downstream".equals(label)) {
                return NEW_CONTEXT_BECOMES_DOWNSTREAM;
            }
            return NEW_CONTEXT_BECOMES_UPSTREAM;
        }
    }
}

