/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.quickfixes;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.StoryFeature;
import org.contextmapper.dsl.contextMappingDSL.UserStory;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class SplitStoryByVerb
implements CMLQuickFix<Feature> {
    private Set<String> defaultVerbs = Sets.newHashSet(Arrays.asList("create", "read", "update", "delete"));
    private Set<String> verbs = Sets.newHashSet(Arrays.asList("create", "read", "update", "delete"));

    @Override
    public void applyQuickfix(Feature contextObject) {
        if (!(contextObject.eContainer() instanceof UserStory)) {
            throw new ContextMapperApplicationException("Cannot apply quickfix, as the provided feature is not embedded into to a user story or use case.");
        }
        UserStory story = (UserStory)contextObject.eContainer();
        if (!(story.eContainer() instanceof ContextMappingModel)) {
            throw new ContextMapperApplicationException("Cannot apply quickfix, as the given story is not part of a CML model.");
        }
        UserStory splitStory = (UserStory)EcoreUtil2.copy((EObject)story);
        splitStory.setName(story.getName() + "_Split");
        StoryFeature feature = (StoryFeature)splitStory.getFeatures().get(0);
        splitStory.getFeatures().clear();
        for (String verb : this.verbs) {
            StoryFeature newFeature = (StoryFeature)EcoreUtil2.copy((EObject)feature);
            if (this.defaultVerbs.contains(verb)) {
                newFeature.setVerb(verb);
            } else {
                newFeature.setVerb("\"" + verb + "\"");
            }
            splitStory.getFeatures().add((Object)newFeature);
        }
        ContextMappingModel model = (ContextMappingModel)story.eContainer();
        model.getUserRequirements().add((Object)splitStory);
        story.setSplittingStory(splitStory);
    }

    @Override
    public void applyQuickfix2EObject(EObject contextObject) {
        if (!(contextObject instanceof Feature)) {
            throw new ContextMapperApplicationException("Cannot apply quickfix, as the given context object is no user story feature.");
        }
        this.applyQuickfix((Feature)contextObject);
    }

    public void setVerbs(Set<String> verbs) {
        this.verbs = Sets.newHashSet(verbs);
    }

    @Override
    public String getName() {
        return "Split Story by Verb/Operation";
    }

    @Override
    public String getDescription() {
        return "Splits a feature in a user story or use case by the verb/operation.";
    }
}

