/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.userrepresentations;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.generator.servicecutter.input.nanoentities.NanoentityResolver;
import org.contextmapper.dsl.generator.servicecutter.input.userrepresentations.CompatibilityBuilder;
import org.contextmapper.dsl.generator.servicecutter.input.userrepresentations.NanoentityCollector;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Aggregate;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.Entity;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.PredefinedService;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SecurityAccessGroup;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SeparatedSecurityZone;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterConfigurationDSLFactory;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterUserRepresentationsModel;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.SharedOwnerGroup;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.UseCase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class UserRepresentationsBuilder {
    private ServiceCutterConfigurationDSLFactory factory = ServiceCutterConfigurationDSLFactory.eINSTANCE;
    private ContextMappingModel contextMappingModel;
    private ServiceCutterUserRepresentationsModel model;
    private CMLModelObjectsResolvingHelper resolvingHelper;
    private NanoentityResolver nanoentityResolver;
    private CompatibilityBuilder compatibilityBuilder;

    public UserRepresentationsBuilder(ContextMappingModel cmlModel) {
        this.contextMappingModel = cmlModel;
        this.resolvingHelper = new CMLModelObjectsResolvingHelper(cmlModel);
        this.model = this.factory.createServiceCutterUserRepresentationsModel();
        this.nanoentityResolver = new NanoentityResolver();
        this.compatibilityBuilder = new CompatibilityBuilder(cmlModel);
    }

    public ServiceCutterUserRepresentationsModel build() {
        this.buildUseCases();
        this.buildAggregates();
        this.buildEntities();
        this.buildPredefinedServices();
        this.buildSharedOwnerGroups();
        this.mapCompatibilities();
        this.buildSeparatedSecurityZones();
        this.buildSecurityAccessGroups();
        return this.model;
    }

    private void buildUseCases() {
        this.model.getUseCases().clear();
        for (UserRequirement ur : this.contextMappingModel.getUserRequirements()) {
            Set<String> nanoEntitiesRead = new NanoentityCollector().getNanoentitiesRead(ur);
            Set<String> nanoEntitiesWritten = new NanoentityCollector().getNanoentitiesWritten(ur);
            if (nanoEntitiesRead.isEmpty() && nanoEntitiesWritten.isEmpty()) continue;
            UseCase uc = this.factory.createUseCase();
            uc.setName(ur.getName());
            uc.getNanoentitiesRead().addAll(nanoEntitiesRead);
            uc.getNanoentitiesWritten().addAll(nanoEntitiesWritten);
            this.model.getUseCases().add((Object)uc);
        }
    }

    private void buildAggregates() {
        this.model.getAggregates().clear();
        for (org.contextmapper.dsl.contextMappingDSL.Aggregate aggregate : this.resolvingHelper.resolveAllAggregates()) {
            Aggregate scAggregate = this.factory.createAggregate();
            scAggregate.setName(aggregate.getName());
            scAggregate.getNanoentities().addAll(this.nanoentityResolver.getAllNanoentities(aggregate));
            this.model.getAggregates().add((Object)scAggregate);
        }
        if (!this.model.getAggregates().isEmpty()) {
            ((Aggregate)this.model.getAggregates().get(0)).setDoc("/* These Aggregates are generated from the CML model. Note that they are overwritten each time you use the service cut generator! */");
        }
    }

    private void buildEntities() {
        this.model.getEntities().clear();
        for (org.contextmapper.tactic.dsl.tacticdsl.Entity entity : EcoreUtil2.eAllOfType((EObject)this.contextMappingModel, org.contextmapper.tactic.dsl.tacticdsl.Entity.class)) {
            Entity scEntity = this.factory.createEntity();
            scEntity.setName(entity.getName());
            scEntity.getNanoentities().addAll(this.nanoentityResolver.getAllNanoentities(entity));
            this.model.getEntities().add((Object)scEntity);
        }
        if (!this.model.getEntities().isEmpty()) {
            ((Entity)this.model.getEntities().get(0)).setDoc("/* These Entities are generated from the CML model. Note that they are overwritten each time you use the service cut generator! */");
        }
    }

    private void buildPredefinedServices() {
        this.model.getPredefinedServices().clear();
        for (BoundedContext bc : this.contextMappingModel.getBoundedContexts()) {
            if (bc.getType().equals((Object)BoundedContextType.TEAM)) continue;
            PredefinedService predefinedService = this.factory.createPredefinedService();
            predefinedService.setName(bc.getName());
            predefinedService.getNanoentities().addAll(this.nanoentityResolver.getAllNanoentities(bc));
            this.model.getPredefinedServices().add((Object)predefinedService);
        }
        if (!this.model.getPredefinedServices().isEmpty()) {
            ((PredefinedService)this.model.getPredefinedServices().get(0)).setDoc("/* These predefined services are generated from the CML model. Note that they are overwritten each time you use the service cut generator! */");
        }
    }

    private void buildSharedOwnerGroups() {
        this.model.getSharedOwnerGroups().clear();
        List allAggregatesWithOwner = this.resolvingHelper.resolveAllAggregates().stream().filter(agg -> agg.getOwner() != null).collect(Collectors.toList());
        if (allAggregatesWithOwner.isEmpty()) {
            return;
        }
        HashMap nanoentitiesPerOwner = Maps.newHashMap();
        for (org.contextmapper.dsl.contextMappingDSL.Aggregate aggregate : allAggregatesWithOwner) {
            if (!nanoentitiesPerOwner.containsKey(aggregate.getOwner().getName())) {
                nanoentitiesPerOwner.put(aggregate.getOwner().getName(), Sets.newHashSet());
            }
            ((Set)nanoentitiesPerOwner.get(aggregate.getOwner().getName())).addAll(this.nanoentityResolver.getAllNanoentities(aggregate));
        }
        for (Map.Entry entry : nanoentitiesPerOwner.entrySet()) {
            SharedOwnerGroup ownerGroup = this.factory.createSharedOwnerGroup();
            ownerGroup.setName((String)entry.getKey());
            ownerGroup.getNanoentities().addAll((Collection)entry.getValue());
            this.model.getSharedOwnerGroups().add((Object)ownerGroup);
        }
        if (!this.model.getSharedOwnerGroups().isEmpty()) {
            ((SharedOwnerGroup)this.model.getSharedOwnerGroups().get(0)).setDoc("/* These shared owner groups are generated from the CML model. Note that they are overwritten each time you use the service cut generator! */");
        }
    }

    private void buildSeparatedSecurityZones() {
        this.model.getSeparatedSecurityZones().clear();
        List allAggregatesWithSecurityZone = this.resolvingHelper.resolveAllAggregates().stream().filter(agg -> agg.getSecurityZone() != null && !"".equals(agg.getSecurityZone())).collect(Collectors.toList());
        Map<String, List<org.contextmapper.dsl.contextMappingDSL.Aggregate>> aggregatesPerSecurityZone = allAggregatesWithSecurityZone.stream().collect(Collectors.groupingBy(org.contextmapper.dsl.contextMappingDSL.Aggregate::getSecurityZone));
        for (Map.Entry<String, List<org.contextmapper.dsl.contextMappingDSL.Aggregate>> entry : aggregatesPerSecurityZone.entrySet()) {
            SeparatedSecurityZone separatedSecurityZone = this.factory.createSeparatedSecurityZone();
            separatedSecurityZone.setName(entry.getKey());
            for (org.contextmapper.dsl.contextMappingDSL.Aggregate aggregate : entry.getValue()) {
                separatedSecurityZone.getNanoentities().addAll(this.nanoentityResolver.getAllNanoentities(aggregate));
            }
            this.model.getSeparatedSecurityZones().add((Object)separatedSecurityZone);
        }
    }

    private void buildSecurityAccessGroups() {
        this.model.getSecurityAccessGroups().clear();
        List allAggregatesWithSecurityAccessGroups = this.resolvingHelper.resolveAllAggregates().stream().filter(agg -> agg.getSecurityAccessGroup() != null && !"".equals(agg.getSecurityAccessGroup())).collect(Collectors.toList());
        Map<String, List<org.contextmapper.dsl.contextMappingDSL.Aggregate>> aggregatesPerSecurityAccessGroup = allAggregatesWithSecurityAccessGroups.stream().collect(Collectors.groupingBy(org.contextmapper.dsl.contextMappingDSL.Aggregate::getSecurityAccessGroup));
        for (Map.Entry<String, List<org.contextmapper.dsl.contextMappingDSL.Aggregate>> entry : aggregatesPerSecurityAccessGroup.entrySet()) {
            SecurityAccessGroup securityAccessGroup = this.factory.createSecurityAccessGroup();
            securityAccessGroup.setName(entry.getKey());
            for (org.contextmapper.dsl.contextMappingDSL.Aggregate aggregate : entry.getValue()) {
                securityAccessGroup.getNanoentities().addAll(this.nanoentityResolver.getAllNanoentities(aggregate));
            }
            this.model.getSecurityAccessGroups().add((Object)securityAccessGroup);
        }
    }

    private void mapCompatibilities() {
        this.model.setCompatibilities(this.compatibilityBuilder.buildCompatibilities());
    }
}

