/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Criticality implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    NORMAL(1, "NORMAL", "NORMAL"),
    HIGH(2, "HIGH", "HIGH"),
    LOW(3, "LOW", "LOW");

    public static final int UNDEFINED_VALUE = 0;
    public static final int NORMAL_VALUE = 1;
    public static final int HIGH_VALUE = 2;
    public static final int LOW_VALUE = 3;
    private static final Criticality[] VALUES_ARRAY;
    public static final List<Criticality> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Criticality get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Criticality result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Criticality getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Criticality result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Criticality get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return NORMAL;
            }
            case 2: {
                return HIGH;
            }
            case 3: {
                return LOW;
            }
        }
        return null;
    }

    private Criticality(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Criticality[]{UNDEFINED, NORMAL, HIGH, LOW};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

