/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContextMapState implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    AS_IS(1, "AS_IS", "AS_IS"),
    TO_BE(2, "TO_BE", "TO_BE");

    public static final int UNDEFINED_VALUE = 0;
    public static final int AS_IS_VALUE = 1;
    public static final int TO_BE_VALUE = 2;
    private static final ContextMapState[] VALUES_ARRAY;
    public static final List<ContextMapState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ContextMapState get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ContextMapState result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ContextMapState getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ContextMapState result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ContextMapState get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return AS_IS;
            }
            case 2: {
                return TO_BE;
            }
        }
        return null;
    }

    private ContextMapState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ContextMapState[]{UNDEFINED, AS_IS, TO_BE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

