/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.validation.AbstractCMLValidator;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class UniquenessValidator
extends AbstractCMLValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateThatBoundedContextNameIsUnique(BoundedContext bc) {
        Iterator<BoundedContext> allBoundedContexts;
        Iterator duplicateBoundedContexts;
        if (bc != null && IteratorExtensions.size((Iterator)(duplicateBoundedContexts = IteratorExtensions.filter(allBoundedContexts = new CMLModelObjectsResolvingHelper(this.getRootCMLModel(bc)).resolveAllObjectsOfType(BoundedContext.class).iterator(), boundedcontext -> boundedcontext.getName().equals(bc.getName())))) > 1) {
            this.error(String.format("Multiple bounded contexts with the name '%s' have been declared.", bc.getName()), bc, (EStructuralFeature)ContextMappingDSLPackage.Literals.BOUNDED_CONTEXT__NAME);
        }
    }

    @Check
    public void validateThatDomainNameIsUnique(Domain domain) {
        Iterator<Domain> allDomains;
        Iterator duplicateDomains;
        if (domain != null && IteratorExtensions.size((Iterator)(duplicateDomains = IteratorExtensions.filter(allDomains = new CMLModelObjectsResolvingHelper(this.getRootCMLModel(domain)).resolveAllObjectsOfType(Domain.class).iterator(), d -> domain.getName().equals(d.getName())))) > 1) {
            this.error(String.format("Multiple domains with the name '%s' have been declared.", domain.getName()), domain, (EStructuralFeature)ContextMappingDSLPackage.Literals.DOMAIN_PART__NAME);
        }
    }

    @Check
    public void validateThatSubdomainNameIsUnique(Subdomain subdomain) {
        Iterator<Subdomain> allSubdomains;
        Iterator duplicateSubdomains;
        if (subdomain != null && IteratorExtensions.size((Iterator)(duplicateSubdomains = IteratorExtensions.filter(allSubdomains = new CMLModelObjectsResolvingHelper(this.getRootCMLModel(subdomain)).resolveAllObjectsOfType(Subdomain.class).iterator(), sd -> subdomain.getName().equals(sd.getName())))) > 1) {
            this.error(String.format("Multiple subdomains with the name '%s' have been declared.", subdomain.getName()), subdomain, (EStructuralFeature)ContextMappingDSLPackage.Literals.DOMAIN_PART__NAME);
        }
    }

    @Check
    public void validateThatModuleNameIsUnique(SculptorModule module) {
        Iterator<SculptorModule> allModules;
        Iterator duplicateModules;
        if (module != null && IteratorExtensions.size((Iterator)(duplicateModules = IteratorExtensions.filter(allModules = new CMLModelObjectsResolvingHelper(this.getRootCMLModel(module)).resolveAllObjectsOfType(SculptorModule.class).iterator(), m -> m.getName().equals(module.getName())))) > 1) {
            this.error(String.format("Duplicate name. There is already an existing Module named '%s'.", module.getName()), module, (EStructuralFeature)ContextMappingDSLPackage.Literals.SCULPTOR_MODULE__NAME);
        }
    }

    @Check
    public void validateThatAggregateNameIsUnique(Aggregate aggregate) {
        Iterator<Aggregate> allAggregates;
        Iterator duplicateAggregates;
        if (aggregate != null && IteratorExtensions.size((Iterator)(duplicateAggregates = IteratorExtensions.filter(allAggregates = new CMLModelObjectsResolvingHelper(this.getRootCMLModel(aggregate)).resolveAllObjectsOfType(Aggregate.class).iterator(), a -> a.getName().equals(aggregate.getName())))) > 1) {
            this.error(String.format("Multiple aggregates with the name '%s' have been declared.", aggregate.getName()), aggregate, (EStructuralFeature)ContextMappingDSLPackage.Literals.AGGREGATE__NAME);
        }
    }

    @Check
    public void validateThatServiceNamesAreUniqueInBoundedContext(BoundedContext bc) {
        HashSet serviceNames = Sets.newHashSet();
        for (Service service : Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)bc), Service.class))) {
            if (serviceNames.contains(service.getName())) {
                this.error(String.format("Multiple services with the name '%s' have been declared in this Bounded Context.", service.getName()), service, (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NAME);
                continue;
            }
            serviceNames.add(service.getName());
        }
    }

    @Check
    public void validateThatServiceNamesAreUniqueInSubdomain(Subdomain subdomain) {
        HashSet serviceNames = Sets.newHashSet();
        for (Service service : Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)subdomain), Service.class))) {
            if (serviceNames.contains(service.getName())) {
                this.error(String.format("Multiple services with the name '%s' have been declared in this Subdomain.", service.getName()), service, (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NAME);
                continue;
            }
            serviceNames.add(service.getName());
        }
    }

    @Check
    public void validateThatUseCaseNameIsUnique(UserRequirement uc) {
        Iterator<UserRequirement> allUseCases;
        Iterator duplicateUseCases;
        if (uc != null && IteratorExtensions.size((Iterator)(duplicateUseCases = IteratorExtensions.filter(allUseCases = new CMLModelObjectsResolvingHelper(this.getRootCMLModel(uc)).resolveAllObjectsOfType(UserRequirement.class).iterator(), u -> u.getName().equals(uc.getName())))) > 1) {
            this.error(String.format("Multiple use cases with the name '%s' have been declared.", uc.getName()), uc, (EStructuralFeature)ContextMappingDSLPackage.Literals.USER_REQUIREMENT__NAME);
        }
    }

    @Check
    public void validateThatDomainObjectsAreUniqueInAggregate(Aggregate agg) {
        if (agg == null) {
            return;
        }
        this.checkDomainObjectUnique((List<SimpleDomainObject>)agg.getDomainObjects());
    }

    @Check
    public void validateThatDomainObjectsAreUniqueInModule(SculptorModule module) {
        if (module == null) {
            return;
        }
        this.checkDomainObjectUnique((List<SimpleDomainObject>)module.getDomainObjects());
    }

    @Check
    public void validateThatDomainObjectsAreUniqueInSubdomain(Subdomain subdomain) {
        if (subdomain == null) {
            return;
        }
        this.checkDomainObjectUnique(subdomain.getEntities().stream().map(e -> e).collect(Collectors.toList()));
    }

    @Check
    public void validateThatFlowNameIsUnique(Flow flow) {
        Iterator allFlows;
        Iterator duplicateFlows;
        if (flow != null && IteratorExtensions.size((Iterator)(duplicateFlows = IteratorExtensions.filter(allFlows = EcoreUtil2.eAllOfType((EObject)this.getRootCMLModel(flow), Flow.class).iterator(), f -> f.getName().equals(flow.getName())))) > 1) {
            this.error(String.format("Multiple flows with the name '%s' have been declared. Please provide unique names!", flow.getName()), flow, (EStructuralFeature)ContextMappingDSLPackage.Literals.FLOW__NAME);
        }
    }

    private void checkDomainObjectUnique(List<SimpleDomainObject> domainObjects) {
        HashSet<String> usedNames = new HashSet<String>();
        for (SimpleDomainObject o : domainObjects) {
            if (o.getName() == null) continue;
            if (usedNames.contains(o.getName())) {
                this.error(String.format("Multiple domain objects with the name '%s' have been declared.", o.getName()), o, (EStructuralFeature)TacticdslPackage.Literals.SIMPLE_DOMAIN_OBJECT__NAME);
                continue;
            }
            usedNames.add(o.getName());
        }
    }
}

