/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import ch.hsr.servicecutter.solver.SolverAlgorithm;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;

public class ExtractSuggestedService
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    public static final String SERVICE_CUTTER_SUGGESTION_FILE_NAME_PATTERN = "(^.*)_(" + String.join((CharSequence)"|", Arrays.asList(SolverAlgorithm.values()).stream().map(a -> a.toString().replace(" ", "_")).collect(Collectors.toList())) + ")_Cut_[0-9].cml";
    private BoundedContext suggestedService;
    private String newBoundedContextName;
    private Map<String, DomainObject> domainObjectMap;

    public ExtractSuggestedService(BoundedContext suggestedService, String newBoundedContextName) {
        this.suggestedService = suggestedService;
        this.checkPreconditions();
        this.newBoundedContextName = newBoundedContextName;
        this.domainObjectMap = Maps.newHashMap();
    }

    @Override
    protected void doRefactor() {
        BoundedContext bc = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
        bc.setName(this.newBoundedContextName);
        Aggregate aggregate = ContextMappingDSLFactory.eINSTANCE.createAggregate();
        aggregate.setName(this.newBoundedContextName + "Aggregate");
        this.addElementToEList(bc.getAggregates(), aggregate);
        List allAttributesInSuggestedService = EcoreUtil2.eAllOfType((EObject)this.suggestedService, Attribute.class);
        List allReferencesInSuggestedService = EcoreUtil2.eAllOfType((EObject)this.suggestedService, Reference.class);
        if (allAttributesInSuggestedService.isEmpty() && allReferencesInSuggestedService.isEmpty()) {
            throw new ContextMapperApplicationException("This suggested service (Bounded Context) does not contain any Entities with data fields. We cannot extract such an empty Bounded Context. Please choose suggested Bounded Contexts that are not empty.");
        }
        for (Attribute serviceCutAttribute : allAttributesInSuggestedService) {
            Attribute attribute = this.findAttributeInOriginalModel(serviceCutAttribute);
            if (attribute == null) continue;
            this.moveAttribute(attribute, aggregate);
        }
        for (Reference serviceCutReference : allReferencesInSuggestedService) {
            Reference reference = this.findReferenceInOriginalModel(serviceCutReference);
            if (reference == null) continue;
            this.moveReference(reference, aggregate);
        }
        this.model.getBoundedContexts().add((Object)bc);
    }

    private void moveAttribute(Attribute attribute, Aggregate newBCAggregate) {
        DomainObject parentObject = (DomainObject)attribute.eContainer();
        DomainObject newDomainObject = this.getNewDomainObject(parentObject, newBCAggregate);
        this.addElementToEList(newDomainObject.getAttributes(), (Attribute)EcoreUtil2.copy((EObject)attribute));
        this.removeElementFromEList(parentObject.getAttributes(), attribute);
    }

    private void moveReference(Reference reference, Aggregate newBCAggregate) {
        DomainObject parentObject = (DomainObject)reference.eContainer();
        DomainObject newDomainObject = this.getNewDomainObject(parentObject, newBCAggregate);
        this.addElementToEList(newDomainObject.getReferences(), (Reference)EcoreUtil2.copy((EObject)reference));
        this.removeElementFromEList(parentObject.getReferences(), reference);
    }

    private Attribute findAttributeInOriginalModel(Attribute serviceCutAttribute) {
        if (!(serviceCutAttribute.eContainer() instanceof DomainObject)) {
            throw new ContextMapperApplicationException("We unexpectedly found attributes that are not contained by 'DomainObject' objects. We currently only support Entities, ValueObjects and Events here.");
        }
        String domainObjectName = ((DomainObject)serviceCutAttribute.eContainer()).getName();
        String attributeName = serviceCutAttribute.getName();
        for (Attribute attribute : EcoreUtil2.eAllOfType((EObject)this.model, Attribute.class).stream().filter(a -> a.getName().equals(attributeName)).collect(Collectors.toList())) {
            if (!(attribute.eContainer() instanceof DomainObject) || !((DomainObject)attribute.eContainer()).getName().equals(domainObjectName)) continue;
            return attribute;
        }
        return null;
    }

    private Reference findReferenceInOriginalModel(Reference serviceCutReference) {
        if (!(serviceCutReference.eContainer() instanceof DomainObject)) {
            throw new ContextMapperApplicationException("We unexpectedly found references that are not contained by 'DomainObject' objects. We currently only support Entities, ValueObjects and Events here.");
        }
        String domainObjectName = ((DomainObject)serviceCutReference.eContainer()).getName();
        String attributeName = serviceCutReference.getName();
        for (Reference reference : EcoreUtil2.eAllOfType((EObject)this.model, Reference.class).stream().filter(r -> r.getName().equals(attributeName)).collect(Collectors.toList())) {
            if (!(reference.eContainer() instanceof DomainObject) || !((DomainObject)reference.eContainer()).getName().equals(domainObjectName)) continue;
            return reference;
        }
        return null;
    }

    private DomainObject getNewDomainObject(DomainObject originalDomainObject, Aggregate newBCAggregate) {
        if (this.domainObjectMap.containsKey(originalDomainObject.getName())) {
            return this.domainObjectMap.get(originalDomainObject.getName());
        }
        DomainObject domainObject = TacticdslFactory.eINSTANCE.createEntity();
        if (originalDomainObject instanceof ValueObject) {
            domainObject = TacticdslFactory.eINSTANCE.createValueObject();
        }
        if (originalDomainObject instanceof DomainEvent) {
            domainObject = TacticdslFactory.eINSTANCE.createDomainEvent();
        }
        domainObject.setName(this.getUniqueDomainObjectName(originalDomainObject.getName()));
        this.addElementToEList(newBCAggregate.getDomainObjects(), domainObject);
        this.domainObjectMap.put(originalDomainObject.getName(), domainObject);
        return domainObject;
    }

    private String getUniqueDomainObjectName(String inputName) {
        Object name = inputName;
        int counter = 2;
        Set existingNames = EcoreUtil2.eAllOfType((EObject)this.model, DomainObject.class).stream().map(o -> o.getName()).collect(Collectors.toSet());
        while (existingNames.contains(name)) {
            name = inputName + "_" + counter;
            ++counter;
        }
        return name;
    }

    public URI constructOriginalModelUri() {
        Resource currentResource = this.suggestedService.eResource();
        String fileName = currentResource.getURI().lastSegment();
        if (!fileName.matches(SERVICE_CUTTER_SUGGESTION_FILE_NAME_PATTERN)) {
            throw new ContextMapperApplicationException("The given file name (" + fileName + ") does not match with the pattern generated by Service Cutter. Please do not rename files generated by Service Cutter. This is how we identify whether a model is a decomposition suggestion or not.");
        }
        Pattern r = Pattern.compile(SERVICE_CUTTER_SUGGESTION_FILE_NAME_PATTERN);
        Matcher m = r.matcher(fileName);
        m.find();
        return currentResource.getURI().trimFileExtension().trimSegments(1).appendSegment(m.group(1)).appendFileExtension("cml");
    }

    private void checkPreconditions() {
        if (this.suggestedService.eResource() == null) {
            throw new ContextMapperApplicationException("The given Bounded Context is not part of a persisted CML resource. Only Bounded Contexts loaded from a persisted CML file are allowed here.");
        }
        this.constructOriginalModelUri();
    }
}

