/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.quickfixes;

import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CreateMissingBoundedContextQuickFix
implements CMLQuickFix<ContextMappingModel> {
    public static final String LINK_DIAGNOSTIC_MESSAGE_PATTERN = "^Couldn't resolve reference to %s '([a-zA-Z_][a-zA-Z0-9_]*)'.";
    private String missingContextName;

    public CreateMissingBoundedContextQuickFix(String missingContextName) {
        this.missingContextName = missingContextName;
    }

    @Override
    public void applyQuickfix(ContextMappingModel model) {
        if (model.getBoundedContexts().stream().anyMatch(bc -> bc.getName().equals(this.missingContextName))) {
            return;
        }
        BoundedContext bc2 = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
        bc2.setName(this.missingContextName);
        model.getBoundedContexts().add((Object)bc2);
        if (model.getMap() != null) {
            model.getMap().getBoundedContexts().add((Object)bc2);
        }
    }

    @Override
    public void applyQuickfix2EObject(EObject contextObject) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)contextObject);
        if (rootContainer != null) {
            CMLQuickFix.super.applyQuickfix2EObject(rootContainer);
        }
    }

    @Override
    public String getName() {
        return "Create a Bounded Context named '" + this.missingContextName + "'.";
    }

    @Override
    public String getDescription() {
        return "Creates the missing Bounded Context.";
    }
}

