/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.userrepresentations;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;

public class NanoentityCollector {
    private static final String DEFAULT_VERB_CREATE = "create";
    private static final String DEFAULT_VERB_READ = "read";
    private static final String DEFAULT_VERB_UPDATE = "update";
    private static final String DEFAULT_VERB_DELETE = "delete";

    public Set<String> getNanoentitiesRead(UserRequirement ur) {
        HashSet nanoEntities = Sets.newHashSet();
        for (Feature feature : ur.getFeatures()) {
            nanoEntities.addAll(this.getNanoentitiesRead(feature));
        }
        return nanoEntities;
    }

    public Set<String> getNanoentitiesWritten(UserRequirement ur) {
        HashSet nanoEntities = Sets.newHashSet();
        for (Feature feature : ur.getFeatures()) {
            nanoEntities.addAll(this.getNanoentitiesWritten(feature));
        }
        return nanoEntities;
    }

    private Set<String> getNanoentitiesRead(Feature feature) {
        String verb = feature.getVerb().toLowerCase();
        if (verb.equals(DEFAULT_VERB_CREATE) || verb.equals(DEFAULT_VERB_UPDATE) || verb.equals(DEFAULT_VERB_DELETE)) {
            return Sets.newHashSet();
        }
        return this.getAllNanoentities(feature);
    }

    private Set<String> getNanoentitiesWritten(Feature feature) {
        String verb = feature.getVerb().toLowerCase();
        if (verb.equals(DEFAULT_VERB_READ)) {
            return Sets.newHashSet();
        }
        return this.getAllNanoentities(feature);
    }

    private Set<String> getAllNanoentities(Feature feature) {
        HashSet nanoEntities = Sets.newHashSet();
        for (String attr : feature.getEntityAttributes().stream().filter(a -> !"".equals(a)).collect(Collectors.toSet())) {
            nanoEntities.add(feature.getEntity().trim() + "." + this.formatAttributeName(attr));
        }
        return nanoEntities;
    }

    private String formatAttributeName(String attr) {
        String trimedAttr = attr.trim();
        if (trimedAttr.length() == 1) {
            return trimedAttr.trim().toLowerCase();
        }
        return trimedAttr.substring(0, 1).toLowerCase() + trimedAttr.substring(1);
    }
}

