/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public abstract class AbstractFreemarkerTextCreator<T> {
    private Configuration freemarkerConfig;
    private Template freemarkerTemplate;

    public AbstractFreemarkerTextCreator() {
        this.loadFreemarkerTemplate();
    }

    public String createText(T modelObject) {
        this.preprocessing(modelObject);
        HashMap<String, Object> root = new HashMap<String, Object>();
        this.registerModelObjects(root, modelObject);
        StringWriter writer = new StringWriter();
        try {
            this.freemarkerTemplate.process(root, (Writer)writer);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in processing freemarker template.", e);
        }
        return writer.toString();
    }

    protected abstract void preprocessing(T var1);

    protected abstract void registerModelObjects(Map<String, Object> var1, T var2);

    protected abstract String getTemplateName();

    protected abstract Class<?> getTemplateClass();

    private void loadFreemarkerTemplate() {
        URL url = this.getTemplateClass().getResource(this.getTemplateName());
        File templateDir = new File(System.getProperty("java.io.tmpdir"), "context-mapper-freemarker-templates-" + this.getPID());
        if (!templateDir.exists()) {
            templateDir.mkdir();
        }
        try {
            FileUtils.copyURLToFile((URL)url, (File)new File(templateDir, this.getTemplateName()));
            this.freemarkerConfig = new Configuration(Configuration.VERSION_2_3_22);
            this.freemarkerConfig.setDirectoryForTemplateLoading(templateDir);
            this.freemarkerConfig.setDefaultEncoding("UTF-8");
            this.freemarkerConfig.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.freemarkerTemplate = this.freemarkerConfig.getTemplate(this.getTemplateName());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load freemarker template!", e);
        }
    }

    private long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }
}

