/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.cml;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLImportResolver;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.DomainPart;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class CMLModelObjectsResolvingHelper {
    private ContextMappingModel rootModel;

    public CMLModelObjectsResolvingHelper(ContextMappingModel rootModel) {
        this.rootModel = rootModel;
    }

    private Set<ContextMappingModel> resolveImportedModels() {
        Set<CMLResource> importedResources = new CMLImportResolver().resolveImportedResources(new CMLResource(this.rootModel.eResource()));
        return importedResources.stream().map(r -> r.getContextMappingModel()).collect(Collectors.toSet());
    }

    public <T extends EObject> Set<T> resolveAllObjectsOfType(Class<T> type) {
        HashSet resultSet = Sets.newHashSet();
        resultSet.addAll(Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)this.rootModel), type)));
        for (ContextMappingModel model : this.resolveImportedModels()) {
            resultSet.addAll(Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)model), type)));
        }
        return resultSet;
    }

    public BoundedContext resolveBoundedContext(Aggregate aggregate) {
        if (aggregate.eContainer() != null && aggregate.eContainer() instanceof SculptorModule) {
            return this.resolveBoundedContext((SculptorModule)aggregate.eContainer());
        }
        return (BoundedContext)aggregate.eContainer();
    }

    public BoundedContext resolveBoundedContext(SculptorModule module) {
        return (BoundedContext)module.eContainer();
    }

    public BoundedContext resolveBoundedContext(SimpleDomainObject domainObject) {
        if (domainObject.eContainer() != null && domainObject.eContainer() instanceof Aggregate) {
            return this.resolveBoundedContext((Aggregate)domainObject.eContainer());
        }
        if (domainObject.eContainer() != null && domainObject.eContainer() instanceof SculptorModule) {
            return this.resolveBoundedContext((SculptorModule)domainObject.eContainer());
        }
        return null;
    }

    public BoundedContext resolveBoundedContext(EObject anyCMLObject) {
        if (anyCMLObject instanceof BoundedContext) {
            return (BoundedContext)anyCMLObject;
        }
        for (EObject parent = anyCMLObject.eContainer(); parent != null; parent = parent.eContainer()) {
            if (!(parent instanceof BoundedContext)) continue;
            return (BoundedContext)parent;
        }
        return null;
    }

    public Aggregate resolveAggregate(EObject anyCMLObject) {
        if (anyCMLObject instanceof Aggregate) {
            return (Aggregate)anyCMLObject;
        }
        for (EObject parent = anyCMLObject.eContainer(); parent != null; parent = parent.eContainer()) {
            if (!(parent instanceof Aggregate)) continue;
            return (Aggregate)parent;
        }
        return null;
    }

    public List<Aggregate> resolveAllAccessibleAggregates(BoundedContext bc) {
        LinkedList aggregates = Lists.newLinkedList();
        aggregates.addAll(EcoreUtil2.eAllOfType((EObject)bc, Aggregate.class));
        ContextMap contextMap = this.getContextMap(bc);
        if (contextMap != null) {
            for (Relationship rel : contextMap.getRelationships()) {
                if (!this.isBCDownstreamInRelationship(rel, bc)) continue;
                aggregates.addAll(this.getExposedAggregates(rel));
            }
        }
        return aggregates;
    }

    public ContextMap getContextMap(BoundedContext bc) {
        if (EcoreUtil2.getRootContainer((EObject)bc) instanceof ContextMappingModel) {
            ContextMappingModel rootModel = (ContextMappingModel)EcoreUtil2.getRootContainer((EObject)bc);
            return rootModel.getMap();
        }
        return null;
    }

    public Set<UserRequirement> resolveUserRequirements(BoundedContext boundedContext) {
        HashSet requirements = Sets.newHashSet();
        for (DomainPart domainPart : boundedContext.getImplementedDomainParts()) {
            if (!(domainPart instanceof Subdomain)) continue;
            Subdomain subdomain = (Subdomain)domainPart;
            requirements.addAll(subdomain.getSupportedFeatures());
        }
        return requirements;
    }

    public Set<Feature> resolveFeatures(BoundedContext boundedContext) {
        HashSet features = Sets.newHashSet();
        this.resolveUserRequirements(boundedContext).forEach(ur -> features.addAll(ur.getFeatures()));
        return features;
    }

    public List<Aggregate> resolveAllAggregates() {
        LinkedList allAggregates = Lists.newLinkedList();
        for (BoundedContext bc : this.rootModel.getBoundedContexts()) {
            allAggregates.addAll(bc.getAggregates());
        }
        return allAggregates;
    }

    public Set<String> resolveAggregateStates(Aggregate aggregate) {
        HashSet aggregateStates = Sets.newHashSet();
        Optional<Enum> optStatesEnum = aggregate.getDomainObjects().stream().filter(o -> o instanceof Enum).map(o -> (Enum)o).filter(o -> o.isDefinesAggregateLifecycle()).findFirst();
        if (optStatesEnum.isPresent()) {
            aggregateStates.addAll(optStatesEnum.get().getValues().stream().map(v -> v.getName()).collect(Collectors.toSet()));
        }
        return aggregateStates;
    }

    private boolean isBCDownstreamInRelationship(Relationship relationship, BoundedContext bc) {
        if (relationship instanceof SymmetricRelationship) {
            SymmetricRelationship symRel = (SymmetricRelationship)relationship;
            return symRel.getParticipant1().getName().equals(bc.getName()) || symRel.getParticipant2().getName().equals(bc.getName());
        }
        if (relationship instanceof UpstreamDownstreamRelationship) {
            UpstreamDownstreamRelationship upDownRel = (UpstreamDownstreamRelationship)relationship;
            return upDownRel.getDownstream().getName().equals(bc.getName());
        }
        return false;
    }

    private List<Aggregate> getExposedAggregates(Relationship relationship) {
        LinkedList aggregates = Lists.newLinkedList();
        if (relationship instanceof SymmetricRelationship) {
            aggregates.addAll(EcoreUtil2.eAllOfType((EObject)((SymmetricRelationship)relationship).getParticipant1(), Aggregate.class));
            aggregates.addAll(EcoreUtil2.eAllOfType((EObject)((SymmetricRelationship)relationship).getParticipant2(), Aggregate.class));
        } else if (relationship instanceof UpstreamDownstreamRelationship) {
            UpstreamDownstreamRelationship upDownRel = (UpstreamDownstreamRelationship)relationship;
            if (upDownRel.getUpstreamExposedAggregates() != null && !upDownRel.getUpstreamExposedAggregates().isEmpty()) {
                aggregates.addAll(upDownRel.getUpstreamExposedAggregates());
            } else {
                aggregates.addAll(EcoreUtil2.eAllOfType((EObject)upDownRel.getUpstream(), Aggregate.class));
            }
        }
        return aggregates;
    }
}

