/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.value_registers;

import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ValueRegister;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class CreateValueRegisterForBoundedContext
extends AbstractRefactoring {
    private String contextName;

    public CreateValueRegisterForBoundedContext(String contextName) {
        this.contextName = contextName;
    }

    @Override
    protected void doRefactor() {
        if (!this.boundedContextAlreadyHasAValueRegister()) {
            BoundedContext selectedBC = this.getSelectedBoundedContext();
            if (selectedBC != null) {
                ValueRegister newVR = ContextMappingDSLFactory.eINSTANCE.createValueRegister();
                newVR.setName("ValueRegisterFor_" + this.contextName);
                newVR.setContext(selectedBC);
                this.model.getValueRegisters().add((Object)newVR);
                this.addComment(selectedBC);
            } else {
                System.err.println("Did not find bounded context " + this.contextName);
            }
        }
    }

    private void addComment(BoundedContext boundedContext) {
        boundedContext.getResponsibilities().add((Object)"Compliance with values in value register");
    }

    private boolean boundedContextAlreadyHasAValueRegister() {
        EList<ValueRegister> vrs = this.model.getValueRegisters();
        for (ValueRegister vr : vrs) {
            if (vr.getContext() == null || !vr.getContext().getName().equals(this.contextName)) continue;
            return true;
        }
        return false;
    }

    private BoundedContext getSelectedBoundedContext() {
        return EcoreUtil2.getAllContentsOfType((EObject)this.model, BoundedContext.class).stream().filter(s -> s.getName().equals(this.contextName)).findFirst().get();
    }
}

