/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.stakeholders;

import java.util.List;
import org.contextmapper.dsl.cml.XtextIdHelper;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.INFLUENCE;
import org.contextmapper.dsl.contextMappingDSL.INTEREST;
import org.contextmapper.dsl.contextMappingDSL.Stakeholder;
import org.contextmapper.dsl.contextMappingDSL.Stakeholders;
import org.contextmapper.dsl.contextMappingDSL.UserStory;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class CreateStakeholderForUserStoryRole
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String userStoryName;
    private XtextIdHelper idHelper;

    public CreateStakeholderForUserStoryRole(String userStoryName) {
        this.userStoryName = userStoryName;
        this.idHelper = new XtextIdHelper();
    }

    @Override
    protected void doRefactor() {
        EObject parentObject;
        UserStory story = this.getSelectedUserStory();
        if (!this.stakeholderForRoleAlreadyExists(story) && (parentObject = story.eContainer()) instanceof ContextMappingModel) {
            ContextMappingModel modelRoot = (ContextMappingModel)story.eContainer();
            Stakeholders stakeholders = this.createStakeholderForStoryRole(story);
            modelRoot.getStakeholders().add((Object)stakeholders);
        }
    }

    private Stakeholders createStakeholderForStoryRole(UserStory story) {
        Stakeholder stakeholderForRole = ContextMappingDSLFactory.eINSTANCE.createStakeholder();
        stakeholderForRole.setName(this.idHelper.convertStringToXtextID(story.getRole()));
        stakeholderForRole.setDescription("Role of/in " + this.userStoryName);
        stakeholderForRole.setInfluence(INFLUENCE.MEDIUM);
        stakeholderForRole.setInterest(INTEREST.MEDIUM);
        Stakeholders stakeholders = ContextMappingDSLFactory.eINSTANCE.createStakeholders();
        stakeholders.getStakeholders().add((Object)stakeholderForRole);
        return stakeholders;
    }

    private UserStory getSelectedUserStory() {
        return EcoreUtil2.getAllContentsOfType((EObject)this.model, UserStory.class).stream().filter(s -> s.getName().equals(this.userStoryName)).findFirst().get();
    }

    public boolean stakeholderForRoleAlreadyExists(UserStory story) {
        ContextMappingModel model = (ContextMappingModel)story.eContainer();
        List allStakeholders = EcoreUtil2.getAllContentsOfType((EObject)model, Stakeholder.class);
        for (Stakeholder stakeholder : allStakeholders) {
            if (!stakeholder.getName().equals(this.idHelper.convertStringToXtextID(story.getRole()))) continue;
            return true;
        }
        return false;
    }
}

