/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.XtextIdHelper;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;

public class DeriveSubdomainFromUserRequirements
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private static final String BENEFIT_SEPARATOR_STRING = "; ";
    private Set<String> userRequiremendIds = Sets.newHashSet();
    private String domainName;
    private String subdomainName;
    private XtextIdHelper idHelper = new XtextIdHelper();

    public DeriveSubdomainFromUserRequirements(String domainName, String subdomainName, Set<String> userRequirements) {
        this.domainName = domainName;
        this.subdomainName = subdomainName;
        this.userRequiremendIds = userRequirements;
    }

    @Override
    protected void doRefactor() {
        Set<UserRequirement> selectedUserRequirements = this.collectUserRequirements();
        if (selectedUserRequirements.isEmpty()) {
            throw new RefactoringInputException("Please provide at least one user story or use case that exists in the CML model.");
        }
        Domain domain = this.getOrCreateDomain();
        Subdomain subdomain = this.getOrCreateSubdomain(domain);
        this.addElementsToEList(subdomain.getSupportedFeatures(), Lists.newLinkedList(selectedUserRequirements));
        LinkedList benefits = Lists.newLinkedList();
        if (subdomain.getDomainVisionStatement() != null && !"".equals(subdomain.getDomainVisionStatement())) {
            benefits.addAll(Arrays.asList(subdomain.getDomainVisionStatement().split(BENEFIT_SEPARATOR_STRING)));
        }
        for (UserRequirement ur : selectedUserRequirements) {
            if (!this.doesContainAtLeastOneEntity(ur)) continue;
            benefits.add("Aims at promoting the following benefit for a " + ur.getRole() + ": " + ur.getBenefit());
            this.deriveSubdomainEntities4Features(subdomain, ur.getName(), (List<Feature>)ur.getFeatures());
        }
        for (UserRequirement ur : selectedUserRequirements) {
            this.deriveSubdomainEntityReferences(subdomain, (List<Feature>)ur.getFeatures());
        }
        subdomain.setDomainVisionStatement(String.join((CharSequence)BENEFIT_SEPARATOR_STRING, benefits));
    }

    private boolean doesContainAtLeastOneEntity(UserRequirement ur) {
        if (ur.getFeatures().isEmpty()) {
            return false;
        }
        Set entityNames = ur.getFeatures().stream().map(f -> f.getEntity()).collect(Collectors.toSet());
        return entityNames.size() != 1 || !"".equals(entityNames.iterator().next());
    }

    private void deriveSubdomainEntities4Features(Subdomain subdomain, String urName, List<Feature> features) {
        for (Feature feature : features) {
            Service service;
            if (feature.getEntity() == null || "".equals(feature.getEntity())) continue;
            String entityName = this.createEntityIfNotExisting(feature.getEntity(), subdomain, (List<String>)feature.getEntityAttributes());
            String serviceName = this.idHelper.convertStringToXtextID(urName.substring(0, 1).toUpperCase() + urName.substring(1) + "Service");
            Optional<Service> alreadyExistingService = subdomain.getServices().stream().filter(s -> serviceName.equals(s.getName())).findFirst();
            if (!alreadyExistingService.isPresent()) {
                service = this.createService(serviceName, entityName, feature.getVerb());
                this.addElementToEList(subdomain.getServices(), service);
            } else {
                service = alreadyExistingService.get();
            }
            String operationName = this.idHelper.convertStringToXtextID(feature.getVerb().replace(" ", "_") + entityName);
            Optional<ServiceOperation> alreadyExistingServiceOperation = service.getOperations().stream().filter(o -> operationName.equals(o.getName())).findFirst();
            if (!alreadyExistingServiceOperation.isPresent()) {
                this.addElementToEList(service.getOperations(), this.createServiceOperation(operationName));
            }
            if (feature.getContainerEntity() == null || "".equals(feature.getContainerEntity())) continue;
            this.createEntityIfNotExisting(feature.getContainerEntity(), subdomain, Lists.newLinkedList());
        }
    }

    private void deriveSubdomainEntityReferences(Subdomain subdomain, List<Feature> features) {
        for (Feature feature : features) {
            if (feature.getContainerEntity() == null || "".equals(feature.getContainerEntity())) continue;
            String containerEntityName = this.mapEntityName(feature.getContainerEntity());
            String referencedEntityName = this.mapEntityName(feature.getEntity());
            Entity containerEntity = subdomain.getEntities().stream().filter(e -> e.getName().equals(containerEntityName)).findFirst().get();
            Entity referencedEntity = subdomain.getEntities().stream().filter(e -> e.getName().equals(referencedEntityName)).findFirst().get();
            String refName = referencedEntity.getName().toLowerCase() + "List";
            if (containerEntity.getReferences().stream().filter(r -> r.getName().equals(refName)).findAny().isPresent()) continue;
            Reference reference = TacticdslFactory.eINSTANCE.createReference();
            reference.setName(refName);
            reference.setCollectionType(CollectionType.LIST);
            reference.setDomainObjectType(referencedEntity);
            this.addElementToEList(containerEntity.getReferences(), reference);
        }
    }

    private String createEntityIfNotExisting(String entity, Subdomain subdomain, List<String> attributes) {
        String entityName = this.mapEntityName(entity);
        Optional<Entity> alreadyExistingEntity = subdomain.getEntities().stream().filter(e -> entityName.equals(e.getName())).findFirst();
        if (!alreadyExistingEntity.isPresent()) {
            Entity newEntity = TacticdslFactory.eINSTANCE.createEntity();
            newEntity.setName(entityName);
            this.createEntityAttributes(newEntity, attributes);
            this.addElementToEList(subdomain.getEntities(), newEntity);
        } else {
            this.createEntityAttributes(alreadyExistingEntity.get(), attributes);
        }
        return entityName;
    }

    private String mapEntityName(String entityName) {
        return this.idHelper.convertStringToXtextID(entityName.trim());
    }

    private void createEntityAttributes(Entity entity, List<String> attributeNames) {
        Set existingAttrNames = entity.getAttributes().stream().map(a -> a.getName()).collect(Collectors.toSet());
        for (String attributeName : attributeNames) {
            String attributeNameEncoded;
            if ("".equals(attributeName.trim()) || existingAttrNames.contains(attributeNameEncoded = this.encodeAttrName(attributeName))) continue;
            Attribute attribute = TacticdslFactory.eINSTANCE.createAttribute();
            attribute.setName(attributeNameEncoded);
            attribute.setType("String");
            this.addElementToEList(entity.getAttributes(), attribute);
        }
    }

    private String encodeAttrName(String originalName) {
        Object name = originalName.trim();
        name = ((String)name).substring(0, 1).toLowerCase() + ((String)name).substring(1);
        return new XtextIdHelper().convertStringToXtextID((String)name);
    }

    private Service createService(String serviceName, String entityName, String verb) {
        Service service = TacticdslFactory.eINSTANCE.createService();
        service.setName(serviceName);
        return service;
    }

    private ServiceOperation createServiceOperation(String operationName) {
        ServiceOperation operation = TacticdslFactory.eINSTANCE.createServiceOperation();
        operation.setName(operationName);
        return operation;
    }

    private Domain getOrCreateDomain() {
        if (this.domainName == null || "".equals(this.domainName)) {
            throw new RefactoringInputException("Please provide a name for the domain where the new subdomain shall be added.");
        }
        Optional<Domain> optDomain = this.getAllDomains().stream().filter(d -> this.domainName.equals(d.getName())).findFirst();
        if (optDomain.isPresent()) {
            return optDomain.get();
        }
        Domain newDomain = ContextMappingDSLFactory.eINSTANCE.createDomain();
        newDomain.setName(this.domainName);
        this.addElementToEList(this.model.getDomains(), newDomain);
        return newDomain;
    }

    private Subdomain getOrCreateSubdomain(Domain domain) {
        if (this.subdomainName == null || "".equals(this.subdomainName)) {
            throw new RefactoringInputException("Please provide a name for the subdomain that shall be created or existing subdomain that shall contain the new entities.");
        }
        Optional<Subdomain> optSubdomain = domain.getSubdomains().stream().filter(sd -> this.subdomainName.equals(sd.getName())).findFirst();
        if (optSubdomain.isPresent()) {
            return optSubdomain.get();
        }
        Subdomain newSubdomain = ContextMappingDSLFactory.eINSTANCE.createSubdomain();
        newSubdomain.setName(this.subdomainName);
        this.addElementToEList(domain.getSubdomains(), newSubdomain);
        return newSubdomain;
    }

    private Set<UserRequirement> collectUserRequirements() {
        HashSet userRequirements = Sets.newHashSet();
        Set<UserRequirement> allUserRequirements = this.getAllUserRequirements();
        for (String urName : this.userRequiremendIds) {
            Optional<UserRequirement> optUR = allUserRequirements.stream().filter(ur -> urName.equals(ur.getName())).findFirst();
            if (!optUR.isPresent()) continue;
            userRequirements.add(optUR.get());
        }
        return userRequirements;
    }
}

