/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.contextmapper.dsl.cml.CMLImportResolver;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Import;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.exception.RefactoringSerializationException;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public abstract class AbstractRefactoring
implements SemanticCMLRefactoring {
    protected ContextMappingModel model;
    protected CMLResource rootResource;
    protected Set<CMLResource> importedResources;
    private Map<BoundedContext, CMLResource> boundedContextsMap = Maps.newHashMap();
    private Map<ContextMap, CMLResource> contextMapMap = Maps.newHashMap();
    private Map<Domain, CMLResource> domainMap = Maps.newHashMap();
    private Map<UserRequirement, CMLResource> userRequirementMap = Maps.newHashMap();
    protected ResourceSet consistencyCheckResources;
    protected Set<CMLResource> additionalResourcesToCheck = Sets.newHashSet();

    @Override
    public void refactor(CMLResource resource) {
        this.rootResource = resource;
        this.importedResources = new CMLImportResolver().resolveImportedResources(this.rootResource);
        this.model = resource.getContextMappingModel();
        this.enableModificationTracking(resource);
        this.resolveRootElements();
        this.doRefactor();
    }

    @Override
    public void refactor(CMLResource resource, ResourceSet consistencyCheckResources) {
        this.consistencyCheckResources = consistencyCheckResources;
        this.enableModificationTracking(consistencyCheckResources);
        for (Resource resourceToCheck : consistencyCheckResources.getResources()) {
            if (resourceToCheck.getContents().isEmpty() || !(resourceToCheck.getContents().get(0) instanceof ContextMappingModel)) continue;
            this.additionalResourcesToCheck.add(new CMLResource(resourceToCheck));
        }
        this.refactor(resource);
    }

    @Override
    public void persistChanges(ISerializer serializer) {
        CMLResource rootResource = this.rootResource;
        if (rootResource.isModified()) {
            this.persistResource(rootResource, serializer);
        }
        if (rootResource.getResourceSet() != null) {
            this.persistChanges(rootResource.getResourceSet(), serializer);
        }
        if (this.consistencyCheckResources != null) {
            this.persistChanges(this.consistencyCheckResources, serializer);
        }
    }

    private void persistChanges(ResourceSet rs, ISerializer serializer) {
        for (Resource resource : rs.getResources()) {
            if (!resource.isModified()) continue;
            this.persistResource(new CMLResource(resource), serializer);
        }
    }

    protected abstract void doRefactor();

    private void enableModificationTracking(CMLResource cmlResource) {
        cmlResource.setTrackingModification(true);
        if (cmlResource.getResourceSet() != null) {
            this.enableModificationTracking(cmlResource.getResourceSet());
        }
    }

    private void enableModificationTracking(ResourceSet rs) {
        for (Resource resource : rs.getResources()) {
            resource.setTrackingModification(true);
        }
    }

    protected Set<BoundedContext> getAllBoundedContexts() {
        return Sets.newHashSet(this.boundedContextsMap.keySet());
    }

    protected Set<ContextMap> getAllContextMaps() {
        return Sets.newHashSet(this.contextMapMap.keySet());
    }

    protected Set<Domain> getAllDomains() {
        return Sets.newHashSet(this.domainMap.keySet());
    }

    protected Set<UserRequirement> getAllUserRequirements() {
        return Sets.newHashSet(this.userRequirementMap.keySet());
    }

    private void persistResource(CMLResource resource, ISerializer serializer) {
        Set<String> serializationErrors = this.serializationDryRun(resource, serializer);
        if (!serializationErrors.isEmpty()) {
            throw new RefactoringSerializationException(serializationErrors);
        }
        try {
            resource.save(SaveOptions.newBuilder().format().getOptions().toOptionsMap());
        }
        catch (IOException e) {
            throw new RuntimeException("Document cannot be formatted.");
        }
    }

    private Set<String> serializationDryRun(CMLResource resource, ISerializer serializer) {
        HashSet errors = Sets.newHashSet();
        try {
            serializer.serialize((EObject)resource.getContextMappingModel());
        }
        catch (Exception e) {
            errors.add(e.getMessage());
        }
        return errors;
    }

    protected CMLResource getResource(BoundedContext bc) {
        CMLResource result = this.boundedContextsMap.get(bc);
        return result;
    }

    private void resolveRootElements() {
        this.resolveAllRootElements(this.rootResource);
        for (CMLResource importedResource : this.importedResources) {
            this.resolveAllRootElements(importedResource);
        }
    }

    private void resolveAllRootElements(CMLResource importedResource) {
        this.resolveBoundedContexts(importedResource);
        this.resolveContextMaps(importedResource);
        this.resolveDomains(importedResource);
        this.resolveUserRequirements(importedResource);
    }

    private void resolveBoundedContexts(CMLResource resource) {
        for (BoundedContext bc : resource.getContextMappingModel().getBoundedContexts()) {
            this.boundedContextsMap.put(bc, resource);
        }
    }

    private void resolveContextMaps(CMLResource resource) {
        if (resource.getContextMappingModel().getMap() != null) {
            this.contextMapMap.put(resource.getContextMappingModel().getMap(), resource);
        }
        for (CMLResource extResourceToCheck : this.additionalResourcesToCheck) {
            if (extResourceToCheck.getContextMappingModel().getMap() == null || !this.containsImport(extResourceToCheck, resource)) continue;
            this.contextMapMap.put(extResourceToCheck.getContextMappingModel().getMap(), extResourceToCheck);
        }
    }

    private void resolveDomains(CMLResource resource) {
        for (Domain domain : resource.getContextMappingModel().getDomains()) {
            this.domainMap.put(domain, resource);
        }
    }

    private void resolveUserRequirements(CMLResource resource) {
        for (UserRequirement userRequirement : resource.getContextMappingModel().getUserRequirements()) {
            this.userRequirementMap.put(userRequirement, resource);
        }
    }

    private boolean containsImport(CMLResource source, CMLResource target) {
        for (Import cmlImport : source.getContextMappingModel().getImports()) {
            if (!URI.createURI((String)cmlImport.getImportURI()).resolve(source.getURI()).toString().equals(target.getURI().toString())) continue;
            return true;
        }
        return false;
    }

    protected <T> void addElementsToEList(EList<T> list, List<T> elementsToAdd) {
        ArrayList tempList = Lists.newArrayList(list);
        list.clear();
        list.addAll((Collection)tempList);
        list.addAll(elementsToAdd);
    }

    protected <T> void addElementToEList(EList<T> list, T elementToAdd) {
        ArrayList tempList = Lists.newArrayList(list);
        list.clear();
        list.addAll((Collection)tempList);
        list.add(elementToAdd);
    }

    protected <T> void removeElementFromEList(EList<T> list, T object) {
        list.remove(object);
        ArrayList tempList = Lists.newArrayList(list);
        list.clear();
        list.addAll((Collection)tempList);
    }
}

