/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.sketchminer.model;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.generator.sketchminer.model.Task;

public class TaskSequence {
    private List<Task> tasks;
    private boolean isSplittingFragment = false;
    private boolean isMergingFragment = false;

    public TaskSequence(Task initialTask) {
        if (initialTask == null) {
            throw new ContextMapperApplicationException("Initial task of a sequence must be defined!");
        }
        this.tasks = Lists.newLinkedList();
        this.tasks.add(initialTask);
    }

    private TaskSequence(List<Task> tasks) {
        this.tasks = Lists.newLinkedList(tasks);
    }

    public boolean addTask(Task task2Add) {
        if (Collections.frequency(this.tasks, task2Add) <= 1) {
            this.tasks.add(task2Add);
            return true;
        }
        return false;
    }

    public List<Task> getTasks() {
        return Lists.newLinkedList(this.tasks);
    }

    public Task getLastTaskInSequence() {
        return this.tasks.get(this.tasks.size() - 1);
    }

    public TaskSequence copy() {
        TaskSequence seq = new TaskSequence(this.tasks);
        seq.isMergingFragment(this.isMergingFragment);
        return seq;
    }

    public boolean isEqualToOtherSequence(TaskSequence otherSequence) {
        return this.tasks.equals(otherSequence.getTasks());
    }

    public boolean isMergingFragment() {
        return this.isMergingFragment;
    }

    public void isMergingFragment(boolean isMergingFragment) {
        this.isMergingFragment = isMergingFragment;
    }

    public boolean isSplittingFragment() {
        return this.isSplittingFragment;
    }

    public void isSplittingFragment(boolean isSplittingFragment) {
        this.isSplittingFragment = isSplittingFragment;
    }
}

