/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.contextmapper.dsl.contextMappingDSL.IMPACT;
import org.contextmapper.dsl.contextMappingDSL.PRIORITY;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.ConsequenceOnValue;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.MitigationAction;

public class Value {
    private final String name;
    private PRIORITY priority;
    private IMPACT impact;
    private final List<String> demonstrators;
    private ConsequenceOnValue consequenceType;
    private String consequence;
    private final List<MitigationAction> mitigationActions;

    public Value(String name) {
        this.name = name;
        this.demonstrators = Lists.newArrayList();
        this.mitigationActions = Lists.newArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setImpact(IMPACT impact) {
        this.impact = impact;
    }

    public IMPACT getImpact() {
        return this.impact;
    }

    public void setPriority(PRIORITY priority) {
        this.priority = priority;
    }

    public PRIORITY getPriority() {
        return this.priority;
    }

    public List<String> getDemonstrators() {
        return Collections.unmodifiableList(this.demonstrators);
    }

    public String getConsequenceType() {
        return this.consequenceType.name();
    }

    public String getConsequence() {
        return this.consequence;
    }

    public void addDemonstrators(List<String> demonstrators) {
        this.demonstrators.addAll(demonstrators);
    }

    public void setConsequence(String consequence) {
        this.consequence = consequence;
    }

    public void setConsequenceType(ConsequenceOnValue consequenceType) {
        this.consequenceType = consequenceType;
    }

    public List<MitigationAction> getMitigationActions() {
        return Collections.unmodifiableList(this.mitigationActions);
    }

    public void addMitigationAction(MitigationAction action) {
        this.mitigationActions.add(action);
    }
}

