/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.Stakeholder;

public class SystemOfInterest {
    private final String name;
    private final Set<Stakeholder> stakeholders;

    public SystemOfInterest(String name) {
        this.name = name;
        this.stakeholders = Sets.newLinkedHashSet();
    }

    public String getName() {
        return this.name;
    }

    public Set<Stakeholder> getStakeholders() {
        return Collections.unmodifiableSet(this.stakeholders);
    }

    public Stakeholder getOrCreateStakeholder(String name, String description) {
        Optional<Stakeholder> optStakeholder = this.stakeholders.stream().filter(s -> s.getName().equals(name)).findFirst();
        if (optStakeholder.isPresent()) {
            return optStakeholder.get();
        }
        Stakeholder stakeholder = new Stakeholder(name, description);
        this.stakeholders.add(stakeholder);
        return stakeholder;
    }
}

