/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.contextmapper.dsl.generator.plantuml.value_impact_mapping.model.Value;

public class Stakeholder {
    private final String name;
    private final String description;
    private final List<Value> values;

    public Stakeholder(String name, String description) {
        this.name = name;
        this.description = description;
        this.values = Lists.newArrayList();
    }

    public String getName() {
        return this.name;
    }

    public List<Value> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public void addValue(Value value) {
        this.values.add(value);
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Stakeholder other = (Stakeholder)obj;
        return Objects.equals(this.name, other.name);
    }
}

